/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nBundle;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nSemanticBundle;
import edu.cornell.mannlib.vitro.webapp.i18n.TranslationProvider;
import edu.cornell.mannlib.vitro.webapp.i18n.selection.SelectedLocale;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.developer.DeveloperSettings;
import edu.cornell.mannlib.vitro.webapp.utils.developer.Key;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class I18n {
    private static final Log log = LogFactory.getLog(I18n.class);
    private static final String ATTRIBUTE_CACHE_CLEARED = I18n.class.getName() + "-cacheCleared";
    private static I18n instance;
    private final ServletContext ctx;
    private AtomicReference<String> themeDirectory = new AtomicReference<String>("");

    protected I18n(ServletContext ctx) {
        this.ctx = ctx;
    }

    public static void setup(ServletContext ctx) {
        instance = new I18n(ctx);
    }

    public static String text(HttpServletRequest req, String key, Object ... parameters) {
        return I18n.bundle(req).text(key, parameters);
    }

    public static I18nBundle bundle(HttpServletRequest req) {
        return instance.getBundle(req);
    }

    public static I18nBundle bundle(List<Locale> preferredLocales) {
        return instance.getBundle(preferredLocales);
    }

    protected I18nBundle getBundle(HttpServletRequest req) {
        this.checkDevelopmentMode(req);
        this.checkForChangeInThemeDirectory(req);
        Locale locale = req.getLocale();
        return new I18nSemanticBundle(Collections.singletonList(locale));
    }

    protected I18nBundle getBundle(List<Locale> preferredLocales) {
        this.checkDevelopmentMode();
        this.checkForChangeInThemeDirectory(this.ctx);
        Locale locale = SelectedLocale.getPreferredLocale(this.ctx, preferredLocales);
        return new I18nSemanticBundle(Collections.singletonList(locale));
    }

    private void checkDevelopmentMode(HttpServletRequest req) {
        if (DeveloperSettings.getInstance().getBoolean(Key.I18N_DEFEAT_CACHE)) {
            log.debug((Object)"In development mode - clearing the cache.");
            this.clearCacheOnRequest(req);
        }
    }

    private void checkDevelopmentMode() {
        if (DeveloperSettings.getInstance().getBoolean(Key.I18N_DEFEAT_CACHE)) {
            log.debug((Object)"In development mode - clearing the cache.");
            this.clearCache();
        }
    }

    private void checkForChangeInThemeDirectory(HttpServletRequest req) {
        String previousDir;
        String currentDir = new VitroRequest(req).getAppBean().getThemeDir();
        if (!currentDir.equals(previousDir = this.themeDirectory.getAndSet(currentDir))) {
            log.debug((Object)("Theme directory changed from '" + previousDir + "' to '" + currentDir + "' - clearing the cache."));
            this.clearCacheOnRequest(req);
        }
    }

    private void checkForChangeInThemeDirectory(ServletContext ctx) {
        String previousDir;
        String currentDir;
        WebappDaoFactory wdf = ModelAccess.on(ctx).getWebappDaoFactory();
        if (Objects.nonNull(wdf) && Objects.nonNull(wdf.getApplicationDao()) && Objects.nonNull(wdf.getApplicationDao().getApplicationBean()) && !(currentDir = wdf.getApplicationDao().getApplicationBean().getThemeDir()).equals(previousDir = this.themeDirectory.getAndSet(currentDir))) {
            log.debug((Object)("Theme directory changed from '" + previousDir + "' to '" + currentDir + "' - clearing the cache."));
            this.clearCache();
        }
    }

    private void clearCache() {
        TranslationProvider.getInstance().clearCache();
    }

    private void clearCacheOnRequest(HttpServletRequest req) {
        if (req.getAttribute(ATTRIBUTE_CACHE_CLEARED) != null) {
            log.debug((Object)"Cache was already cleared on this request.");
        } else {
            this.clearCache();
            log.debug((Object)"Cache cleared.");
            req.setAttribute(ATTRIBUTE_CACHE_CLEARED, (Object)Boolean.TRUE);
        }
    }
}

