/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filestorage.serving;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.filestorage.model.FileInfo;
import edu.cornell.mannlib.vitro.webapp.modules.fileStorage.FileStorage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="serveFiles", urlPatterns={"/file/*"})
public class FileServingServlet
extends VitroHttpServlet {
    private static final String PATH_MISSING_LINK_IMAGE = "/images/missingLink.png";
    private static final Log log = LogFactory.getLog(FileServingServlet.class);
    private FileStorage fileStorage;

    public void init() throws ServletException {
        super.init();
        this.fileStorage = ApplicationUtils.instance().getFileStorage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpServletRequest rawRequest, HttpServletResponse response) throws ServletException, IOException {
        InputStream in;
        VitroRequest request = new VitroRequest(rawRequest);
        String path = request.getServletPath() + request.getPathInfo();
        log.debug((Object)("Path is '" + path + "'"));
        String mimeType = null;
        try {
            FileInfo fileInfo = this.figureFileInfo(request.getWebappDaoFactory(), path);
            mimeType = fileInfo.getMimeType();
            String actualFilename = this.findAndValidateFilename(fileInfo, path);
            in = this.openImageInputStream(fileInfo, actualFilename);
        }
        catch (FileServingException e) {
            log.info((Object)("Failed to serve the file at '" + path + "' -- " + e));
            in = this.openMissingLinkImage(request);
            mimeType = "image/png";
        }
        catch (Exception e) {
            log.warn((Object)("Failed to serve the file at '" + path + "' -- " + e));
            in = this.openMissingLinkImage(request);
            mimeType = "image/png";
        }
        response.setStatus(200);
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        ServletOutputStream out = null;
        try {
            int howMany;
            out = response.getOutputStream();
            byte[] buffer = new byte[8192];
            while (-1 != (howMany = in.read(buffer))) {
                out.write(buffer, 0, howMany);
            }
        }
        catch (IOException e) {
            log.warn((Object)"Failed to serve the file", (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                log.warn((Object)("Serving " + request.getRequestURI() + ". Failed to close input stream."), (Throwable)e);
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    log.warn((Object)("Serving " + request.getRequestURI() + ". Failed to close output stream."), (Throwable)e);
                }
            }
        }
    }

    private FileInfo figureFileInfo(WebappDaoFactory fullWadf, String path) throws FileServingException {
        FileInfo fileInfo = FileInfo.instanceFromAliasUrl(fullWadf, path, this.getServletContext());
        if (fileInfo == null) {
            throw new FileServingException("The request path is not valid for the File servlet: '" + path + "'");
        }
        log.debug((Object)("File info is '" + fileInfo + "'"));
        return fileInfo;
    }

    private String findAndValidateFilename(FileInfo fileInfo, String path) throws FileServingException {
        String requestedFilename = this.figureFilename(path);
        String actualFilename = fileInfo.getFilename();
        if (!actualFilename.equals(requestedFilename) && !actualFilename.equals(this.decode(requestedFilename))) {
            throw new FileServingException("The requested filename does not match the actual filename; request: '" + path + "', actual: '" + actualFilename + "'");
        }
        log.debug((Object)("Actual filename is '" + actualFilename + "'"));
        return actualFilename;
    }

    private String figureFilename(String path) {
        int slashHere = path.lastIndexOf(47);
        if (slashHere == -1) {
            return path;
        }
        return path.substring(slashHere + 1);
    }

    private String decode(String filename) {
        try {
            return URLDecoder.decode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"No UTF-8 decoder? How did this happen?", (Throwable)e);
            return filename;
        }
    }

    private InputStream openImageInputStream(FileInfo fileInfo, String actualFilename) throws IOException {
        return this.fileStorage.getInputStream(fileInfo.getBytestreamUri(), actualFilename);
    }

    private InputStream openMissingLinkImage(VitroRequest vreq) throws FileNotFoundException {
        InputStream stream = vreq.getSession().getServletContext().getResourceAsStream(PATH_MISSING_LINK_IMAGE);
        if (stream == null) {
            throw new FileNotFoundException("No image file at '/images/missingLink.png'");
        }
        return stream;
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private static class FileServingException
    extends Exception {
        public FileServingException(String message) {
            super(message);
        }
    }
}

