/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filestorage.model;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.filestorage.FileServingHelper;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileInfo {
    private static final Log log = LogFactory.getLog(FileInfo.class);
    private final String uri;
    private final String filename;
    private final String mimeType;
    private final String bytestreamUri;
    private final String bytestreamAliasUrl;

    public static FileInfo instanceFromAliasUrl(WebappDaoFactory webappDaoFactory, String path, ServletContext ctx) {
        String bytestreamUri = FileServingHelper.getBytestreamUri(path, ctx);
        if (bytestreamUri == null) {
            return null;
        }
        return FileInfo.instanceFromBytestreamUri(webappDaoFactory, bytestreamUri);
    }

    public static FileInfo instanceFromBytestreamUri(WebappDaoFactory webappDaoFactory, String bytestreamUri) {
        ObjectPropertyStatementImpl opStmt;
        IndividualDao individualDao = webappDaoFactory.getIndividualDao();
        Individual entity = individualDao.getIndividualByURI(bytestreamUri);
        if (!FileInfo.isFileBytestream(entity)) {
            return null;
        }
        ObjectPropertyStatementDao objectPropertyStatementDao = webappDaoFactory.getObjectPropertyStatementDao();
        List<ObjectPropertyStatement> stmts = objectPropertyStatementDao.getObjectPropertyStatements(opStmt = new ObjectPropertyStatementImpl(null, "http://vitro.mannlib.cornell.edu/ns/vitro/public#downloadLocation", entity.getURI()));
        if (stmts.size() > 1) {
            StringBuilder uris = new StringBuilder();
            for (ObjectPropertyStatement stmt : stmts) {
                uris.append("'").append(stmt.getSubjectURI()).append("' ");
            }
            log.warn((Object)("Found " + stmts.size() + " Individuals that claim '" + entity.getURI() + "' as its bytestream:" + uris));
        }
        if (stmts.isEmpty()) {
            log.warn((Object)("No individual claims '" + entity.getURI() + "' as its bytestream."));
            return null;
        }
        String surrogateUri = stmts.get(0).getSubjectURI();
        return FileInfo.instanceFromSurrogateUri(webappDaoFactory, surrogateUri);
    }

    public static FileInfo instanceFromSurrogateUri(WebappDaoFactory webappDaoFactory, String uri) {
        IndividualDao individualDao = webappDaoFactory.getIndividualDao();
        Individual surrogate = individualDao.getIndividualByURI(uri);
        if (!FileInfo.isFileSurrogate(surrogate)) {
            return null;
        }
        String filename = surrogate.getDataValue("http://vitro.mannlib.cornell.edu/ns/vitro/public#filename");
        if (filename == null) {
            log.error((Object)("File had no filename: '" + uri + "'"));
            return null;
        }
        log.debug((Object)("Filename for '" + uri + "' was '" + filename + "'"));
        String mimeType = surrogate.getDataValue("http://vitro.mannlib.cornell.edu/ns/vitro/public#mimeType");
        if (mimeType == null) {
            log.error((Object)("File had no mimeType: '" + uri + "'"));
            return null;
        }
        log.debug((Object)("mimeType for '" + uri + "' was '" + mimeType + "'"));
        Individual byteStream = surrogate.getRelatedIndividual("http://vitro.mannlib.cornell.edu/ns/vitro/public#downloadLocation");
        if (byteStream == null) {
            log.error((Object)("File surrogate '" + uri + "' had no associated bytestream."));
            return null;
        }
        String bytestreamUri = FileInfo.findBytestreamUri(byteStream, uri);
        if (bytestreamUri == null) {
            log.error((Object)("Bytestream of file surrogate '" + uri + "' had no URI: " + byteStream));
            return null;
        }
        String bytestreamAliasUrl = FileInfo.findBytestreamAliasUrl(byteStream, uri);
        if (bytestreamAliasUrl == null) {
            log.error((Object)("Bytestream  '" + bytestreamUri + "' had no alias URL."));
            return null;
        }
        return new Builder().setUri(uri).setFilename(filename).setMimeType(mimeType).setBytestreamUri(bytestreamUri).setBytestreamAliasUrl(bytestreamAliasUrl).build();
    }

    private static boolean isFileBytestream(Individual entity) {
        if (entity == null) {
            return false;
        }
        if (entity.isVClass("http://vitro.mannlib.cornell.edu/ns/vitro/public#FileByteStream")) {
            log.debug((Object)("Entity '" + entity.getURI() + "' is a bytestream"));
            return true;
        }
        log.debug((Object)("Entity '" + entity.getURI() + "' is not a bytestream"));
        return false;
    }

    private static boolean isFileSurrogate(Individual entity) {
        if (entity == null) {
            return false;
        }
        if (entity.isVClass("http://vitro.mannlib.cornell.edu/ns/vitro/public#File")) {
            log.debug((Object)("Entity '" + entity.getURI() + "' is a file surrogate"));
            return true;
        }
        log.debug((Object)("Entity '" + entity.getURI() + "' is not a file surrogate"));
        return false;
    }

    private static String findBytestreamUri(Individual byteStream, String surrogateUri) {
        if (byteStream == null) {
            return null;
        }
        String bytestreamUri = byteStream.getURI();
        log.debug((Object)("File surrogate'" + surrogateUri + "' had associated bytestream: '" + byteStream.getURI() + "'"));
        return bytestreamUri;
    }

    private static String findBytestreamAliasUrl(Individual byteStream, String surrogateUri) {
        if (byteStream == null) {
            return null;
        }
        String aliasUrl = byteStream.getDataValue("http://vitro.mannlib.cornell.edu/ns/vitro/public#directDownloadUrl");
        if (aliasUrl == null) {
            log.error((Object)("File had no aliasUrl: '" + surrogateUri + "'"));
        } else {
            log.debug((Object)("aliasUrl for '" + surrogateUri + "' was '" + aliasUrl + "'"));
        }
        return aliasUrl;
    }

    private FileInfo(Builder builder) {
        this.uri = builder.uri;
        this.filename = builder.filename;
        this.mimeType = builder.mimeType;
        this.bytestreamUri = builder.bytestreamUri;
        this.bytestreamAliasUrl = builder.bytestreamAliasUrl;
    }

    public String getUri() {
        return this.uri;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getBytestreamUri() {
        return this.bytestreamUri;
    }

    public String getBytestreamAliasUrl() {
        return this.bytestreamAliasUrl;
    }

    public String toString() {
        return "FileInfo[uri=" + this.uri + ", filename=" + this.filename + ", mimeType=" + this.mimeType + ", bytestreamUri=" + this.bytestreamUri + ", aliasUrl=" + this.bytestreamAliasUrl + "]";
    }

    public static class Builder {
        private String uri;
        private String filename;
        private String mimeType;
        private String bytestreamUri;
        private String bytestreamAliasUrl;

        public Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder setFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder setMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder setBytestreamUri(String bytestreamUri) {
            this.bytestreamUri = bytestreamUri;
            return this;
        }

        public Builder setBytestreamAliasUrl(String bytestreamAliasUrl) {
            this.bytestreamAliasUrl = bytestreamAliasUrl;
            return this;
        }

        public FileInfo build() {
            return new FileInfo(this);
        }
    }
}

