/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filestorage.impl;

import edu.cornell.mannlib.vitro.webapp.filestorage.impl.InvalidCharacterException;
import edu.cornell.mannlib.vitro.webapp.filestorage.impl.InvalidPathException;
import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileStorageHelper {
    private static final Log log = LogFactory.getLog(FileStorageHelper.class);
    public static final char HEX_ESCAPE_CHAR = '^';
    public static final String HEX_ENCODE_SOURCES = "\"*+,<=>?^|\\~";
    public static final char[] PATH_SINGLE_CHARACTER_SOURCES = new char[]{'/', ':', '.'};
    public static final char[] PATH_SINGLE_CHARACTER_TARGETS = new char[]{'=', '+', ','};
    public static final char[] NAME_SINGLE_CHARACTER_SOURCES = new char[]{'/', ':'};
    public static final char[] NAME_SINGLE_CHARACTER_TARGETS = new char[]{'=', '+'};
    public static final String[] WINDOWS_RESERVED_NAMES = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};

    public static String encodeName(String filename) {
        String hexed = FileStorageHelper.addHexEncoding(filename);
        String cleaned = FileStorageHelper.addSingleCharacterConversions(hexed, NAME_SINGLE_CHARACTER_SOURCES, NAME_SINGLE_CHARACTER_TARGETS);
        return FileStorageHelper.excludeWindowsReservedNames(cleaned);
    }

    private static String addHexEncoding(String clear) {
        for (int i = 0; i < clear.length(); ++i) {
            char c = clear.charAt(i);
            if (c <= '\u00ff') continue;
            throw new InvalidCharacterException(c, i, clear);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < clear.length(); ++i) {
            result.append(FileStorageHelper.hexEncodeCharacter(clear.charAt(i)));
        }
        log.debug((Object)("Add hex encodings to '" + clear + "' giving '" + result + "'"));
        return result.toString();
    }

    private static String hexEncodeCharacter(char c) {
        if (c < '!' || c > '~' || HEX_ENCODE_SOURCES.indexOf(c) >= 0) {
            return "" + '^' + FileStorageHelper.toHexDigit(c / 16) + FileStorageHelper.toHexDigit(c % 16);
        }
        return Character.toString(c);
    }

    private static char toHexDigit(int i) {
        return "0123456789abcdef".charAt(i);
    }

    private static String addSingleCharacterConversions(String encoded, char[] sources, char[] targets) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < encoded.length(); ++i) {
            char c = encoded.charAt(i);
            result.append(FileStorageHelper.translateSingleCharacter(c, sources, targets));
        }
        log.debug((Object)("Add single character conversions to '" + encoded + "' giving '" + result + "'"));
        return result.toString();
    }

    private static char translateSingleCharacter(char c, char[] from, char[] to) {
        for (int j = 0; j < from.length; ++j) {
            if (c != from[j]) continue;
            return to[j];
        }
        return c;
    }

    private static String excludeWindowsReservedNames(String cleanedName) {
        for (String word : WINDOWS_RESERVED_NAMES) {
            if (!word.equalsIgnoreCase(cleanedName)) continue;
            return '~' + cleanedName;
        }
        return cleanedName;
    }

    public static String decodeName(String stored) {
        String unexcluded = FileStorageHelper.unexcludeWindowsReservedNames(stored);
        String hexed = FileStorageHelper.removeSingleCharacterConversions(unexcluded, NAME_SINGLE_CHARACTER_SOURCES, NAME_SINGLE_CHARACTER_TARGETS);
        return FileStorageHelper.removeHexEncoding(hexed);
    }

    private static String unexcludeWindowsReservedNames(String stored) {
        if (stored.startsWith("~")) {
            String remainder = stored.substring(1);
            for (String word : WINDOWS_RESERVED_NAMES) {
                if (!word.equalsIgnoreCase(remainder)) continue;
                return remainder;
            }
        }
        return stored;
    }

    private static String removeSingleCharacterConversions(String cleaned, char[] sources, char[] targets) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < cleaned.length(); ++i) {
            char c = cleaned.charAt(i);
            result.append(FileStorageHelper.translateSingleCharacter(c, targets, sources));
        }
        log.debug((Object)("Remove single character conversions from '" + cleaned + "' giving '" + result + "'"));
        return result.toString();
    }

    private static String removeHexEncoding(String encoded) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < encoded.length(); ++i) {
            char c = encoded.charAt(i);
            if (c == '^') {
                try {
                    if (i + 2 >= encoded.length()) {
                        throw new InvalidPathException("Invalid hex encoding in path: '" + encoded + "'");
                    }
                    String hexChars = encoded.substring(i + 1, i + 3);
                    int value = Integer.parseInt(hexChars, 16);
                    result.append((char)value);
                    i += 2;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new InvalidPathException("Invalid hex encoding in path: '" + encoded + "'", e);
                }
            }
            result.append(c);
        }
        log.debug((Object)("Remove hex encodings from '" + encoded + "' giving '" + result + "'"));
        return result.toString();
    }

    public static String id2Path(String id, Map<Character, String> namespacesMap) {
        char prefix = '\u0000';
        String localName = id;
        for (Map.Entry<Character, String> entry : namespacesMap.entrySet()) {
            String namespace = entry.getValue();
            if (!id.startsWith(namespace)) continue;
            prefix = entry.getKey().charValue();
            localName = id.substring(namespace.length());
            break;
        }
        String hexed = FileStorageHelper.addHexEncoding(localName);
        String cleaned = FileStorageHelper.addSingleCharacterConversions(hexed, PATH_SINGLE_CHARACTER_SOURCES, PATH_SINGLE_CHARACTER_TARGETS);
        String prefixed = FileStorageHelper.applyPrefixChar(prefix, cleaned);
        String brokenUp = FileStorageHelper.insertPathDelimiters(prefixed);
        String result = FileStorageHelper.excludeWindowsWordsFromPath(brokenUp);
        log.debug((Object)("id2Path: id='" + id + "', namespaces='" + namespacesMap + "', path='" + result + "'"));
        return result;
    }

    private static String applyPrefixChar(char prefix, String cleaned) {
        if (prefix == '\u0000') {
            return cleaned;
        }
        return prefix + "~" + cleaned;
    }

    private static String insertPathDelimiters(String prefixed) {
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < prefixed.length(); ++i) {
            if (i % 3 == 0 && i > 0) {
                path.append(File.separatorChar);
            }
            path.append(prefixed.charAt(i));
        }
        log.debug((Object)("Insert path delimiters to '" + prefixed + "' giving '" + path + "'"));
        return path.toString();
    }

    private static String excludeWindowsWordsFromPath(String rawPath) {
        String path = rawPath.replace(File.separatorChar, '/');
        String[] parts = path.split("/");
        StringBuilder newPath = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String part = FileStorageHelper.excludeWindowsReservedNames(parts[i]);
            if (i > 0) {
                newPath.append(File.separatorChar);
            }
            newPath.append(part);
        }
        return newPath.toString();
    }

    public static File getPathToIdDirectory(String id, Map<Character, String> namespacesMap, File rootDir) {
        return new File(rootDir, FileStorageHelper.id2Path(id, namespacesMap));
    }

    public static File getFullPath(File rootDir, String id, String filename, Map<Character, String> namespacesMap) {
        return new File(FileStorageHelper.getPathToIdDirectory(id, namespacesMap, rootDir), FileStorageHelper.encodeName(filename));
    }
}

