/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.controller;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationAJAXGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.controller.EditRequestDispatchController;
import edu.cornell.mannlib.vitro.webapp.utils.log.LogUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="EditRequestAJAX", urlPatterns={"/editRequestAJAX"})
public class EditRequestAJAXController
extends VitroHttpServlet {
    private static final long serialVersionUID = 1L;
    public static Log log = LogFactory.getLog(EditRequestDispatchController.class);

    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.DO_FRONT_END_EDITING.ACTION;
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
        log.debug((Object)LogUtils.formatRequestProperties(log, "debug", req));
        VitroRequest vreq = new VitroRequest(req);
        try {
            EditConfigurationVTwo config = this.getEditConfiguration(vreq);
            String generatorName = vreq.getParameter("generator");
            String javaGeneratorName = "edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators." + generatorName;
            EditConfigurationAJAXGenerator generator = this.getAJAXGenerator(javaGeneratorName, vreq, vreq.getSession());
            generator.modifyEditConfiguration(config, vreq);
        }
        catch (Exception ex) {
            log.error((Object)"An error occurred in retrieving configuration and/or generator ", (Throwable)ex);
        }
    }

    protected EditConfigurationVTwo getEditConfiguration(VitroRequest vreq) {
        EditConfigurationVTwo config = EditConfigurationVTwo.getConfigFromSession(vreq.getSession(), (HttpServletRequest)vreq);
        return config;
    }

    private EditConfigurationAJAXGenerator getAJAXGenerator(String editConfGeneratorName, VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationAJAXGenerator EditConfigurationVTwoGenerator = null;
        Object object = null;
        try {
            Class<?> classDefinition = Class.forName(editConfGeneratorName);
            object = classDefinition.newInstance();
            EditConfigurationVTwoGenerator = object;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            System.out.println(e);
        }
        if (EditConfigurationVTwoGenerator == null) {
            throw new Error("Could not find EditConfigurationVTwoGenerator " + editConfGeneratorName);
        }
        return EditConfigurationVTwoGenerator;
    }
}

