/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VitroVocabulary;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeWithPrecisionVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.BaseEditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.utils.FrontEndEditingUtils;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpSession;

public class DateTimeValueFormGenerator
extends BaseEditConfigurationGenerator
implements EditConfigurationGenerator {
    static final String vivoCore = "http://vivoweb.org/ontology/core#";
    final String toDateTimeValue = "http://vivoweb.org/ontology/core#dateTimeValue";
    static final String valueType = "http://vivoweb.org/ontology/core#DateTimeValue";
    static final String dateTimeValue = "http://vivoweb.org/ontology/core#dateTime";
    static final String dateTimePrecision = "http://vivoweb.org/ontology/core#dateTimePrecision";

    @Override
    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        conf.setTemplate(this.getTemplate());
        conf.setVarNameForSubject("subject");
        conf.setVarNameForPredicate("toDateTimeValue");
        conf.setVarNameForObject("valueNode");
        conf.setN3Optional(Arrays.asList(this.getN3ForValue()));
        conf.addNewResource("valueNode", "");
        conf.addSparqlForExistingLiteral("dateTimeField-value", this.getExistingDateTimeValueQuery());
        conf.addSparqlForExistingUris("dateTimeField-precision", this.getExistingPrecisionQuery());
        FieldVTwo dateTimeField = new FieldVTwo().setName(this.getDateTimeFieldName());
        dateTimeField.setEditElement(new DateTimeWithPrecisionVTwo(dateTimeField, VitroVocabulary.Precision.SECOND.uri(), VitroVocabulary.Precision.NONE.uri()));
        conf.addField(dateTimeField);
        this.addFormSpecificData(conf, vreq);
        this.prepare(vreq, conf);
        return conf;
    }

    protected String getN3ForValue() {
        return "?subject <" + this.getToDateTimeValuePredicate() + "> ?valueNode . \n?valueNode a <" + valueType + "> . \n?valueNode  <" + dateTimeValue + "> ?dateTimeField-value . \n?valueNode  <" + dateTimePrecision + "> ?dateTimeField-precision .";
    }

    protected String getExistingDateTimeValueQuery() {
        return "SELECT ?existingDateTimeValue WHERE { \n?subject <" + this.getToDateTimeValuePredicate() + "> ?valueNode . \n?valueNode a <" + valueType + "> . \n?valueNode <" + dateTimeValue + "> ?existingDateTimeValue }";
    }

    protected String getExistingPrecisionQuery() {
        return "SELECT ?existingPrecision WHERE { \n?subject <" + this.getToDateTimeValuePredicate() + "> ?valueNode . \n?valueNode a <" + valueType + "> . \n?valueNode <" + dateTimePrecision + "> ?existingPrecision }";
    }

    public static String getNodeVar() {
        return "valueNode";
    }

    public static String getNodeN3Var() {
        return "?" + DateTimeValueFormGenerator.getNodeVar();
    }

    protected String getToDateTimeValuePredicate() {
        return this.toDateTimeValue;
    }

    protected String getDateTimeFieldName() {
        return "dateTimeField";
    }

    protected String getTemplate() {
        return "dateTimeValueForm.ftl";
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, Object> formSpecificData = new HashMap<String, Object>();
        formSpecificData.put("editMode", this.getEditMode(vreq).name().toLowerCase());
        formSpecificData.put("domainUri", this.getDomainUri(vreq));
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    public FrontEndEditingUtils.EditMode getEditMode(VitroRequest vreq) {
        String objectUri = EditConfigurationUtils.getObjectUri(vreq);
        FrontEndEditingUtils.EditMode editMode = FrontEndEditingUtils.EditMode.ADD;
        if (objectUri != null && !objectUri.isEmpty()) {
            editMode = FrontEndEditingUtils.EditMode.EDIT;
        }
        return editMode;
    }

    private String getDomainUri(VitroRequest vreq) {
        String domainUri = vreq.getParameter("domainUri");
        return domainUri;
    }
}

