/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields;

import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.i18n.I18nBundle;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.vocabulary.OWL;

public class ChildVClassesOptions
implements FieldOptions {
    private static final String LEFT_BLANK = "";
    private String vclassUri;
    private String defaultOptionLabel;
    static Log log = LogFactory.getLog(ChildVClassesOptions.class);

    public ChildVClassesOptions(String vclassUri) {
        this.vclassUri = vclassUri;
    }

    public ChildVClassesOptions setDefaultOptionLabel(String label) {
        this.defaultOptionLabel = label;
        return this;
    }

    @Override
    public Map<String, String> getOptions(EditConfigurationVTwo editConfig, String fieldName, WebappDaoFactory wDaoFact, I18nBundle i18n) throws Exception {
        VClassDao vclassDao;
        List<String> subClassList;
        LinkedHashMap<String, String> optionsMap = new LinkedHashMap<String, String>();
        int optionsCount = 0;
        if (this.vclassUri == null || this.vclassUri.equals(LEFT_BLANK)) {
            throw new Exception("no vclassUri found for field \"" + fieldName + "\" in SelectListGenerator.getOptions() when OptionsType CHILD_VCLASSES specified");
        }
        if (this.defaultOptionLabel != null) {
            optionsMap.put(LEFT_BLANK, this.defaultOptionLabel);
        }
        if ((subClassList = (vclassDao = wDaoFact.getVClassDao()).getAllSubClassURIs(this.vclassUri)) == null || subClassList.size() == 0) {
            log.debug((Object)("No subclasses of " + this.vclassUri + " found in the model so only default value from field's literalOptions will be used"));
        } else {
            for (String subClassUri : subClassList) {
                VClass subClass = vclassDao.getVClassByURI(subClassUri);
                if (subClass == null || OWL.Nothing.getURI().equals(subClassUri)) continue;
                optionsMap.put(subClassUri, subClass.getName().trim());
                ++optionsCount;
            }
        }
        log.debug((Object)("added " + optionsCount + " options for field \"" + fieldName + "\""));
        return optionsMap;
    }

    public String getClassUri() {
        return this.vclassUri;
    }

    @Override
    public Comparator<String[]> getCustomComparator() {
        return null;
    }
}

