/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceGraph;
import edu.cornell.mannlib.vitro.webapp.dao.jena.SparqlGraph;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.shared.Lock;
import org.apache.jena.shared.LockMRSW;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.util.iterator.SingletonIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class RDFServiceDatasetGraph
implements DatasetGraph {
    private RDFService rdfService;
    private RDFServiceGraph defaultGraph;
    private Lock lock = new LockMRSW();
    private Context context = new Context();
    private Map<String, RDFServiceGraph> graphCache = new ConcurrentHashMap<String, RDFServiceGraph>();
    private ReadWrite transactionMode;
    private TxnType transactionType;

    public RDFServiceDatasetGraph(RDFService rdfService) {
        this.rdfService = rdfService;
        this.defaultGraph = new RDFServiceGraph(rdfService);
    }

    public Map<String, RDFServiceGraph> getGraphCache() {
        return this.graphCache;
    }

    public synchronized void begin(ReadWrite mode) {
        this.transactionMode = mode;
        this.graphCache.clear();
    }

    public void begin(TxnType txnType) {
        this.transactionType = txnType;
        this.graphCache.clear();
    }

    public synchronized void commit() {
        this.transactionMode = null;
        this.transactionType = null;
        if (this.supportsTransactions((Graph)this.defaultGraph)) {
            this.defaultGraph.getTransactionHandler().commit();
        }
        for (RDFServiceGraph graph : this.graphCache.values()) {
            if (!this.supportsTransactions((Graph)graph)) continue;
            graph.getTransactionHandler().commit();
        }
        this.graphCache.clear();
    }

    public synchronized void abort() {
        this.transactionMode = null;
        if (this.supportsTransactions((Graph)this.defaultGraph)) {
            this.defaultGraph.getTransactionHandler().abort();
        }
        for (RDFServiceGraph graph : this.graphCache.values()) {
            if (!this.supportsTransactions((Graph)graph)) continue;
            graph.getTransactionHandler().abort();
        }
        this.graphCache.clear();
    }

    public boolean isInTransaction() {
        return this.transactionMode != null || this.transactionType != null;
    }

    public TxnType transactionType() {
        return this.transactionType;
    }

    public ReadWrite transactionMode() {
        return this.transactionMode;
    }

    public boolean promote(Transactional.Promote promote) {
        return false;
    }

    public void end() {
        this.transactionMode = null;
    }

    private Graph getGraphFor(Quad q) {
        return this.getGraphFor(q.getGraph());
    }

    private Graph getGraphFor(Node g) {
        return g == Node.ANY ? this.defaultGraph : this.getGraph(g);
    }

    public void add(Quad arg0) {
        this.getGraphFor(arg0).add(new Triple(arg0.getSubject(), arg0.getPredicate(), arg0.getObject()));
    }

    public void add(Node g, Node s, Node p, Node o) {
        this.add(new Quad(g, s, p, o));
    }

    public void addGraph(Node uri, Graph arg1) {
    }

    public void close() {
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsTransactionAbort() {
        return true;
    }

    public boolean contains(Quad arg0) {
        return this.getGraphFor(arg0).contains(new Triple(arg0.getSubject(), arg0.getPredicate(), arg0.getObject()));
    }

    public void clear() {
    }

    public boolean contains(Node arg0, Node arg1, Node arg2, Node arg3) {
        return this.getGraphFor(arg0).contains(arg1, arg2, arg3);
    }

    public boolean containsGraph(Node arg0) {
        return this.getGraphFor(arg0) != null;
    }

    public void delete(Quad arg0) {
        this.getGraphFor(arg0).delete(new Triple(arg0.getSubject(), arg0.getPredicate(), arg0.getObject()));
    }

    public void delete(Node g, Node s, Node p, Node o) {
        this.delete(new Quad(g, s, p, o));
    }

    public void deleteAny(Node arg0, Node arg1, Node arg2, Node arg3) {
        this.getGraphFor(arg0).delete(new Triple(arg1, arg2, arg3));
    }

    public Iterator<Quad> find() {
        return this.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }

    public Iterator<Quad> find(Quad arg0) {
        return this.find(arg0.getSubject(), arg0.getPredicate(), arg0.getObject(), arg0.getGraph());
    }

    public Iterator<Quad> find(final Node graph, final Node subject, final Node predicate, final Node object) {
        if (!(this.isVar(subject) || this.isVar(predicate) || this.isVar(object) || this.isVar(graph))) {
            if (this.contains(subject, predicate, object, graph)) {
                return new SingletonIterator((Object)new Quad(subject, predicate, object, graph));
            }
            return WrappedIterator.create(Collections.emptyIterator());
        }
        StringBuilder findQuery = new StringBuilder("SELECT * WHERE { \n");
        String graphURI = !this.isVar(graph) ? graph.getURI() : null;
        findQuery.append("  GRAPH ");
        if (graphURI != null) {
            findQuery.append("  <").append(graphURI).append(">");
        } else {
            findQuery.append("?g");
        }
        findQuery.append(" { ");
        findQuery.append(SparqlGraph.sparqlNode(subject, "?s")).append(" ").append(SparqlGraph.sparqlNode(predicate, "?p")).append(" ").append(SparqlGraph.sparqlNode(object, "?o"));
        findQuery.append("  } ");
        findQuery.append("\n}");
        final ArrayList quadlist = new ArrayList();
        try {
            this.rdfService.sparqlSelectQuery(findQuery.toString(), new ResultSetConsumer(){

                @Override
                protected void processQuerySolution(QuerySolution qs) {
                    Quad q = new Quad(RDFServiceDatasetGraph.this.isVar(graph) ? qs.get("?g").asNode() : graph, RDFServiceDatasetGraph.this.isVar(subject) ? qs.get("?s").asNode() : subject, RDFServiceDatasetGraph.this.isVar(predicate) ? qs.get("?p").asNode() : predicate, RDFServiceDatasetGraph.this.isVar(object) ? qs.get("?o").asNode() : object);
                    quadlist.add(q);
                }
            });
        }
        catch (RDFServiceException rdfse) {
            throw new RuntimeException(rdfse);
        }
        return WrappedIterator.create(quadlist.iterator());
    }

    public Iterator<Quad> findNG(Node arg0, Node arg1, Node arg2, Node arg3) {
        return this.find(arg0, arg1, arg2, arg3);
    }

    public Context getContext() {
        return this.context;
    }

    public RDFServiceGraph getDefaultGraph() {
        return this.defaultGraph;
    }

    public RDFServiceGraph getGraph(Node arg0) {
        String graphURI = arg0.getURI();
        if (this.graphCache.containsKey(graphURI)) {
            return this.graphCache.get(graphURI);
        }
        RDFServiceGraph graph = new RDFServiceGraph(this.rdfService, arg0.getURI());
        this.graphCache.put(graphURI, graph);
        if (this.supportsTransactions((Graph)graph) && (this.transactionMode != null || this.transactionType != null)) {
            graph.getTransactionHandler().begin();
        }
        return graph;
    }

    public RDFServiceGraph getUnionGraph() {
        return this.defaultGraph;
    }

    private boolean supportsTransactions(Graph graph) {
        return graph.getTransactionHandler() != null && graph.getTransactionHandler().transactionsSupported();
    }

    public Lock getLock() {
        return this.lock;
    }

    public boolean isEmpty() {
        return false;
    }

    public Iterator<Node> listGraphNodes() {
        ArrayList<Node> graphNodeList = new ArrayList<Node>();
        try {
            for (String graphURI : this.rdfService.getGraphURIs()) {
                graphNodeList.add(NodeFactory.createURI((String)graphURI));
            }
        }
        catch (RDFServiceException rdfse) {
            throw new RuntimeException(rdfse);
        }
        return graphNodeList.iterator();
    }

    public void removeGraph(Node arg0) {
    }

    public void setDefaultGraph(Graph arg0) {
    }

    public long size() {
        return 0L;
    }

    private boolean isVar(Node node) {
        return node == null || node.isVariable() || node == Node.ANY;
    }

    public String toString() {
        return "RDFServiceDatasetGraph[" + ToString.hashHex(this) + ", " + this.rdfService + "]";
    }
}

