/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstance;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapperFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.EditEvent;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.IntersectionClass;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.ontology.Restriction;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDFS;

public class PropertyDaoJena
extends JenaBaseDao
implements PropertyDao {
    protected static final Log log = LogFactory.getLog((String)PropertyDaoJena.class.getName());
    protected static final String FAUX_PROPERTY_FLAG = "FAUX";
    private static final Map<String, String> NAMESPACES = new HashMap<String, String>(){
        {
            this.put("owl", "http://www.w3.org/2002/07/owl#");
            this.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            this.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
            this.put("vitro", "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#");
            this.put("vitroPublic", "http://vitro.mannlib.cornell.edu/ns/vitro/public#");
        }
    };
    protected static final String PREFIXES;
    protected RDFService rdfService;
    protected DatasetWrapperFactory dwf;
    private static final int DEPTH_LIMIT = 20;

    public PropertyDaoJena(RDFService rdfService, DatasetWrapperFactory dwf, WebappDaoFactoryJena wadf) {
        super(wadf);
        this.rdfService = rdfService;
        this.dwf = dwf;
    }

    @Override
    protected OntModel getOntModel() {
        return this.getOntModelSelector().getTBoxModel();
    }

    protected RDFService getRDFService() {
        return this.rdfService;
    }

    public void addSuperproperty(ObjectProperty property, ObjectProperty superproperty) {
        this.addSuperproperty(property.getURI(), superproperty.getURI());
    }

    @Override
    public void addSuperproperty(String propertyURI, String superpropertyURI) {
        this.getOntModel().enterCriticalSection(false);
        try {
            this.getOntModel().add(this.getOntModel().getResource(propertyURI), RDFS.subPropertyOf, (RDFNode)this.getOntModel().getResource(superpropertyURI));
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
    }

    public void removeSuperproperty(ObjectProperty property, ObjectProperty superproperty) {
        this.removeSuperproperty(property.getURI(), superproperty.getURI());
    }

    @Override
    public void removeSuperproperty(String propertyURI, String superpropertyURI) {
        this.getOntModel().enterCriticalSection(false);
        try {
            if (this.getOntModel().contains(this.getOntModel().getResource(propertyURI), RDFS.subPropertyOf, (RDFNode)this.getOntModel().getResource(superpropertyURI))) {
                this.getOntModel().remove(this.getOntModel().getResource(propertyURI), RDFS.subPropertyOf, (RDFNode)this.getOntModel().getResource(superpropertyURI));
            }
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
    }

    public void addSubproperty(ObjectProperty property, ObjectProperty subproperty) {
        this.addSuperproperty(subproperty, property);
    }

    @Override
    public void addSubproperty(String propertyURI, String subpropertyURI) {
        this.addSuperproperty(subpropertyURI, propertyURI);
    }

    public void removeSubproperty(ObjectProperty property, ObjectProperty subproperty) {
        this.removeSuperproperty(subproperty, property);
    }

    @Override
    public void removeSubproperty(String propertyURI, String subpropertyURI) {
        this.removeSuperproperty(subpropertyURI, propertyURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSubPropertyURIs(String propertyURI) {
        LinkedList<String> subURIs = new LinkedList<String>();
        this.getOntModel().enterCriticalSection(true);
        try {
            ExtendedIterator subIt = this.getOntModel().getOntProperty(propertyURI).listSubProperties(true);
            while (subIt.hasNext()) {
                try {
                    OntProperty prop = (OntProperty)subIt.next();
                    subURIs.add(prop.getURI());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        return subURIs;
    }

    private void getAllSubPropertyURIs(String propertyURI, HashSet<String> subtree) {
        List<String> directSubproperties = this.getSubPropertyURIs(propertyURI);
        for (String uri : directSubproperties) {
            if (subtree.contains(uri)) continue;
            subtree.add(uri);
            this.getAllSubPropertyURIs(uri, subtree);
        }
    }

    @Override
    public List<String> getAllSubPropertyURIs(String propertyURI) {
        HashSet<String> nodeSet = new HashSet<String>();
        nodeSet.add(propertyURI);
        this.getAllSubPropertyURIs(propertyURI, nodeSet);
        nodeSet.remove(propertyURI);
        LinkedList<String> outputList = new LinkedList<String>();
        outputList.addAll(nodeSet);
        return outputList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSuperPropertyURIs(String propertyURI, boolean direct) {
        LinkedList<String> supURIs = new LinkedList<String>();
        this.getOntModel().enterCriticalSection(true);
        try {
            ExtendedIterator supIt = this.getOntModel().getOntProperty(propertyURI).listSuperProperties(direct);
            while (supIt.hasNext()) {
                try {
                    OntProperty prop = (OntProperty)supIt.next();
                    supURIs.add(prop.getURI());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get super-properties for " + propertyURI), (Throwable)e);
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        return supURIs;
    }

    private void getAllSuperPropertyURIs(String propertyURI, HashSet<String> subtree) {
        List<String> directSuperproperties = this.getSuperPropertyURIs(propertyURI, true);
        for (String uri : directSuperproperties) {
            if (subtree.contains(uri)) continue;
            subtree.add(uri);
            this.getAllSuperPropertyURIs(uri, subtree);
        }
    }

    @Override
    public List<String> getAllSuperPropertyURIs(String propertyURI) {
        HashSet<String> nodeSet = new HashSet<String>();
        nodeSet.add(propertyURI);
        this.getAllSuperPropertyURIs(propertyURI, nodeSet);
        nodeSet.remove(propertyURI);
        LinkedList<String> outputList = new LinkedList<String>();
        outputList.addAll(nodeSet);
        return outputList;
    }

    @Override
    public void addSubproperty(edu.cornell.mannlib.vitro.webapp.beans.Property property, edu.cornell.mannlib.vitro.webapp.beans.Property subproperty) {
        this.addSubproperty(property.getURI(), subproperty.getURI());
    }

    @Override
    public void addSuperproperty(edu.cornell.mannlib.vitro.webapp.beans.Property property, edu.cornell.mannlib.vitro.webapp.beans.Property superproperty) {
        this.addSuperproperty(property.getURI(), superproperty.getURI());
    }

    @Override
    public void removeSubproperty(edu.cornell.mannlib.vitro.webapp.beans.Property property, edu.cornell.mannlib.vitro.webapp.beans.Property subproperty) {
        this.removeSubproperty(property.getURI(), subproperty.getURI());
    }

    @Override
    public void removeSuperproperty(edu.cornell.mannlib.vitro.webapp.beans.Property property, edu.cornell.mannlib.vitro.webapp.beans.Property superproperty) {
        this.removeSuperproperty(property.getURI(), superproperty.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEquivalentProperty(String propertyURI, String equivalentPropertyURI) {
        if (propertyURI == null || equivalentPropertyURI == null) {
            throw new RuntimeException("cannot assert equivalence of anonymous properties");
        }
        OntModel ontModel = this.getOntModel();
        ontModel.enterCriticalSection(false);
        try {
            Resource property = ontModel.getResource(propertyURI);
            Resource equivalentProperty = ontModel.getResource(equivalentPropertyURI);
            ontModel.add(property, OWL.equivalentProperty, (RDFNode)equivalentProperty);
            ontModel.add(equivalentProperty, OWL.equivalentProperty, (RDFNode)property);
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public void addEquivalentProperty(edu.cornell.mannlib.vitro.webapp.beans.Property property, edu.cornell.mannlib.vitro.webapp.beans.Property equivalentProperty) {
        this.addEquivalentProperty(property.getURI(), equivalentProperty.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getEquivalentPropertyURIs(String propertyURI) {
        LinkedList<String> equivURIs = new LinkedList<String>();
        this.getOntModel().enterCriticalSection(true);
        try {
            StmtIterator eqStmtIt = this.getOntModel().listStatements(this.getOntModel().getResource(propertyURI), OWL.equivalentProperty, (RDFNode)null);
            while (eqStmtIt.hasNext()) {
                Statement eqStmt = eqStmtIt.nextStatement();
                RDFNode prop = eqStmt.getObject();
                if (!prop.isResource() || ((Resource)prop).getURI() == null) continue;
                equivURIs.add(((Resource)prop).getURI());
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            this.getOntModel().leaveCriticalSection();
        }
        return equivURIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEquivalentProperty(String propertyURI, String equivalentPropertyURI) {
        if (propertyURI == null || equivalentPropertyURI == null) {
            throw new RuntimeException("cannot remove equivalence axiom about anonymous properties");
        }
        OntModel ontModel = this.getOntModel();
        ontModel.enterCriticalSection(false);
        try {
            Resource property = ontModel.getResource(propertyURI);
            Resource equivalentProperty = ontModel.getResource(equivalentPropertyURI);
            ontModel.remove(property, OWL.equivalentProperty, (RDFNode)equivalentProperty);
            ontModel.remove(equivalentProperty, OWL.equivalentProperty, (RDFNode)property);
        }
        finally {
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public void removeEquivalentProperty(edu.cornell.mannlib.vitro.webapp.beans.Property property, edu.cornell.mannlib.vitro.webapp.beans.Property equivalentProperty) {
        this.removeEquivalentProperty(property.getURI(), equivalentProperty.getURI());
    }

    protected void removeABoxStatementsWithPredicate(edu.cornell.mannlib.vitro.webapp.beans.Property predicate) {
        if (predicate == null) {
            log.debug((Object)"Cannot remove ABox statements with a null predicate.");
        } else {
            this.removeABoxStatementsWithPredicate(predicate.getURI());
        }
    }

    protected void removeABoxStatementsWithPredicate(String predicateURI) {
        if (predicateURI == null) {
            log.debug((Object)"Cannot remove ABox statements with null predicate URI.");
            return;
        }
        OntModel aboxModel = this.getOntModelSelector().getABoxModel();
        aboxModel.enterCriticalSection(false);
        try {
            aboxModel.getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), true));
            aboxModel.removeAll((Resource)null, aboxModel.getProperty(predicateURI), (RDFNode)null);
        }
        finally {
            aboxModel.getBaseModel().notifyEvent((Object)new EditEvent(this.getWebappDaoFactory().getUserURI(), false));
            aboxModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VClass> getClassesWithRestrictionOnProperty(String propertyURI) {
        if (propertyURI == null) {
            log.warn((Object)"getClassesWithRestrictionOnProperty: called with null propertyURI");
            return null;
        }
        OntModel ontModel = this.getOntModel();
        ontModel.enterCriticalSection(true);
        HashSet<String> classURISet = new HashSet<String>();
        try {
            Resource targetProp = ontModel.getResource(propertyURI);
            if (targetProp != null) {
                StmtIterator stmtIter = ontModel.listStatements((Resource)null, OWL.onProperty, (RDFNode)targetProp);
                while (stmtIter.hasNext()) {
                    Statement statement = (Statement)stmtIter.next();
                    if (statement.getSubject().canAs(OntClass.class)) {
                        classURISet.addAll(this.getRestrictedClasses((OntClass)statement.getSubject().as(OntClass.class)));
                        continue;
                    }
                    log.warn((Object)"getClassesWithRestrictionOnProperty: Unexpected use of onProperty: it is not applied to a class");
                }
            } else {
                log.error((Object)("getClassesWithRestrictionOnProperty: Error: didn't find a Property in the ontology model for the URI: " + propertyURI));
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        ArrayList<VClass> classes = new ArrayList<VClass>();
        Iterator iter = classURISet.iterator();
        VClassDao vcd = this.getWebappDaoFactory().getVClassDao();
        while (iter.hasNext()) {
            String curi = (String)iter.next();
            VClass vc = vcd.getVClassByURI(curi);
            if (vc != null) {
                classes.add(vc);
                continue;
            }
            log.error((Object)("getClassesWithRestrictionOnProperty: Error: no VClass found for URI: " + curi));
        }
        return classes.size() > 0 ? classes : null;
    }

    public HashSet<String> getRestrictedClasses(OntClass ontClass) {
        HashSet<String> classSet = new HashSet<String>();
        List classList = ontClass.listEquivalentClasses().toList();
        classList.addAll(ontClass.listSubClasses().toList());
        for (OntClass oc : classList) {
            if (!oc.isAnon()) {
                classSet.add(oc.getURI());
                continue;
            }
            classSet.addAll(this.getRestrictedClasses(oc));
        }
        return classSet;
    }

    protected void getPropertyQueryResults(String queryString, ResultSetConsumer consumer) {
        log.debug((Object)("SPARQL query:\n" + queryString));
        try {
            this.getRDFService().sparqlSelectQuery(queryString, consumer);
        }
        catch (RDFServiceException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Resource> getPropertiesWithAppropriateDomainFor(String vclassURI) {
        ArrayList<Resource> propertyResList = new ArrayList<Resource>();
        String queryStr = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX owl:   <http://www.w3.org/2002/07/owl#> \n\n SELECT ?p WHERE { \n  { \n    ?p rdfs:domain <" + vclassURI + "> . \n  } UNION { \n    ?parent rdfs:domain <" + vclassURI + "> . \n    ?p rdfs:subPropertyOf* ?parent. \n    OPTIONAL { \n      ?p rdfs:domain ?childDomain \n    } \n    FILTER (!bound(?childDomain)) \n  } UNION { \n    ?f rdf:first <" + vclassURI + "> . \n    ?u rdf:rest* ?f . \n    ?d owl:unionOf ?u . \n    ?p rdfs:domain ?d . \n  } UNION { \n    ?f rdf:first <" + vclassURI + "> . \n    ?u rdf:rest* ?f . \n    ?d owl:unionOf ?u . \n    ?parent rdfs:domain ?d . \n    ?p rdfs:subPropertyOf* ?parent. \n    OPTIONAL { \n      ?p rdfs:domain ?childDomain \n    } \n    FILTER (!bound(?childDomain)) \n  } \n  FILTER(?p != owl:bottomDataProperty \n      && ?p != owl:bottomObjectProperty) \n}";
        Query q = QueryFactory.create((String)queryStr, (Syntax)Syntax.syntaxSPARQL_11);
        try (QueryExecution qe = QueryExecutionFactory.create((Query)q, (Model)this.getOntModelSelector().getTBoxModel());){
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution qs = rs.nextSolution();
                propertyResList.add(qs.getResource("p"));
            }
        }
        return propertyResList;
    }

    public List<PropertyInstance> getAllPossiblePropInstForIndividual(String individualURI) {
        Individual ind = this.getWebappDaoFactory().getIndividualDao().getIndividualByURI(individualURI);
        VClassDao vcDao = this.getWebappDaoFactory().getVClassDao();
        List<VClass> allTypes = ind.getVClasses(false);
        HashSet<String> allSuperclassURIs = new HashSet<String>();
        for (VClass type : allTypes) {
            String classURI = type.getURI();
            if (classURI != null) {
                allSuperclassURIs.add(type.getURI());
            }
            for (String equivURI : vcDao.getEquivalentClassURIs(classURI)) {
                allSuperclassURIs.add(equivURI);
                allSuperclassURIs.addAll(vcDao.getAllSuperClassURIs(equivURI));
            }
            allSuperclassURIs.addAll(vcDao.getAllSuperClassURIs(classURI));
        }
        ArrayList<VClass> vclasses = new ArrayList<VClass>();
        for (String vclassURI : allSuperclassURIs) {
            VClass vclass = vcDao.getVClassByURI(vclassURI);
            if (vclass == null) continue;
            vclasses.add(vclass);
        }
        return this.getAllPropInstByVClasses(vclasses);
    }

    public List<PropertyInstance> getAllPropInstByVClass(String classURI) {
        if (classURI == null || classURI.length() < 1) {
            return null;
        }
        VClassDao vcDao = this.getWebappDaoFactory().getVClassDao();
        HashSet<String> allSuperclassURIs = new HashSet<String>();
        allSuperclassURIs.add(classURI);
        for (String equivURI : vcDao.getEquivalentClassURIs(classURI)) {
            allSuperclassURIs.add(equivURI);
            allSuperclassURIs.addAll(vcDao.getAllSuperClassURIs(equivURI));
        }
        allSuperclassURIs.addAll(vcDao.getAllSuperClassURIs(classURI));
        ArrayList<VClass> vclasses = new ArrayList<VClass>();
        for (String vclassURI : allSuperclassURIs) {
            VClass vclass = vcDao.getVClassByURI(vclassURI);
            if (vclass == null) continue;
            vclasses.add(vclass);
        }
        return this.getAllPropInstByVClasses(vclasses);
    }

    private void updatePropertyRangeMap(Map<String, Resource[]> map, String propURI, Resource[] ranges, boolean replaceIfMoreSpecific) {
        Resource[] existingRanges = map.get(propURI);
        if (existingRanges == null) {
            map.put(propURI, ranges);
        } else if (existingRanges[0] == null && existingRanges[1] != null) {
            existingRanges[0] = ranges[0];
            map.put(propURI, existingRanges);
        } else if (existingRanges[0] != null) {
            if (existingRanges[1] == null) {
                existingRanges[1] = ranges[1];
            }
            if (ranges[0] != null && this.moreSpecificThan(ranges[0], existingRanges[0])) {
                existingRanges[0] = ranges[0];
            }
            map.put(propURI, existingRanges);
        }
    }

    private boolean moreSpecificThan(Resource r1, Resource r2) {
        if (r1.getURI() == null) {
            return false;
        }
        if (r2.getURI() == null) {
            return true;
        }
        return this.getWebappDaoFactory().getVClassDao().isSubClassOf(r1.getURI(), r2.getURI());
    }

    private List<OntClass> listSuperClasses(OntClass ontClass) {
        return this.relatedClasses(ontClass, RDFS.subClassOf);
    }

    private List<OntClass> listEquivalentClasses(OntClass ontClass) {
        return this.relatedClasses(ontClass, OWL.equivalentClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OntClass> relatedClasses(OntClass ontClass, Property property) {
        ArrayList<OntClass> classes = new ArrayList<OntClass>();
        try (StmtIterator closeIt = ontClass.listProperties(property);){
            while (closeIt.hasNext()) {
                Statement stmt = closeIt.nextStatement();
                if (!stmt.getObject().canAs(OntClass.class)) continue;
                classes.add((OntClass)stmt.getObject().as(OntClass.class));
            }
        }
        return classes;
    }

    private List<Restriction> getRelatedRestrictions(OntClass ontClass) {
        ArrayList<Restriction> restList = new ArrayList<Restriction>();
        this.addRelatedRestrictions(ontClass, restList, 20);
        return restList;
    }

    private void addRelatedRestrictions(OntClass ontClass, List<Restriction> relatedRestrictions, int limit) {
        --limit;
        if (ontClass.isRestriction()) {
            relatedRestrictions.add((Restriction)ontClass.as(Restriction.class));
        } else if (ontClass.isIntersectionClass()) {
            IntersectionClass inter = (IntersectionClass)ontClass.as(IntersectionClass.class);
            ExtendedIterator operIt = inter.listOperands();
            while (operIt.hasNext()) {
                OntClass operand = (OntClass)operIt.next();
                if (relatedRestrictions.contains(operand) || limit <= 0) continue;
                this.addRelatedRestrictions(operand, relatedRestrictions, limit);
            }
        } else {
            List<OntClass> superClasses = this.listSuperClasses(ontClass);
            superClasses.addAll(this.listEquivalentClasses(ontClass));
            for (OntClass sup : superClasses) {
                if (!sup.isAnon() || sup.equals(ontClass) || relatedRestrictions.contains(ontClass) || limit <= 0) continue;
                this.addRelatedRestrictions(sup, relatedRestrictions, limit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PropertyInstance> getAllPropInstByVClasses(List<VClass> vclasses) {
        ArrayList<PropertyInstance> propInsts = new ArrayList<PropertyInstance>();
        if (vclasses == null || vclasses.isEmpty()) {
            return propInsts;
        }
        OntModel ontModel = this.getOntModelSelector().getTBoxModel();
        try {
            ontModel.enterCriticalSection(true);
            HashMap<String, Resource[]> applicableProperties = new HashMap<String, Resource[]>();
            try {
                for (VClass vclass : vclasses) {
                    String VClassURI;
                    OntClass ontClass;
                    if (vclass.isAnonymous() || (ontClass = this.getOntClass(ontModel, VClassURI = vclass.getURI())) == null) continue;
                    List<Restriction> relatedRestrictions = this.getRelatedRestrictions(ontClass);
                    for (Restriction restriction : relatedRestrictions) {
                        OntProperty onProperty = restriction.getOnProperty();
                        if (onProperty == null) continue;
                        Resource[] ranges = new Resource[2];
                        if (restriction.isAllValuesFromRestriction()) {
                            ranges[0] = restriction.asAllValuesFromRestriction().getAllValuesFrom();
                            this.updatePropertyRangeMap(applicableProperties, onProperty.getURI(), ranges, true);
                            continue;
                        }
                        if (!restriction.isSomeValuesFromRestriction()) continue;
                        ranges[1] = restriction.asSomeValuesFromRestriction().getSomeValuesFrom();
                        this.updatePropertyRangeMap(applicableProperties, onProperty.getURI(), ranges, false);
                    }
                    List<Resource> propertyList = this.getPropertiesWithAppropriateDomainFor(VClassURI);
                    for (Resource prop : propertyList) {
                        if (prop.getNameSpace() == null || this.NONUSER_NAMESPACES.contains(prop.getNameSpace())) continue;
                        StmtIterator rangeSit = prop.listProperties(RDFS.range);
                        Resource rangeRes = null;
                        while (rangeSit.hasNext()) {
                            Statement s = rangeSit.nextStatement();
                            if (!s.getObject().isURIResource()) continue;
                            rangeRes = (Resource)s.getObject();
                        }
                        Resource[] ranges = new Resource[2];
                        ranges[0] = rangeRes;
                        this.updatePropertyRangeMap(applicableProperties, prop.getURI(), ranges, false);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to get applicable properties by examining property restrictions and domains", (Throwable)e);
            }
            for (String propertyURI : applicableProperties.keySet()) {
                OntProperty op = ontModel.getOntProperty(propertyURI);
                if (op == null) continue;
                Resource[] foundRanges = (Resource[])applicableProperties.get(propertyURI);
                Resource rangeRes = foundRanges[0] != null ? foundRanges[0] : (op.getRange() == null && foundRanges[1] != null ? foundRanges[1] : op.getRange());
                OntResource domainRes = op.getDomain();
                propInsts.add(this.getPropInst(op, (Resource)domainRes, rangeRes));
                List<PropertyDao.FullPropertyKey> list = this.getAdditionalFauxSubpropertyKeysForPropertyURI(propertyURI);
                for (PropertyDao.FullPropertyKey fauxSubpropertyKey : list) {
                    boolean applicablePropInst = false;
                    if (rangeRes != null && this.getWebappDaoFactory().getVClassDao().isSubClassOf(rangeRes.getURI(), fauxSubpropertyKey.getRangeUri())) continue;
                    if (fauxSubpropertyKey.getDomainUri() == null) {
                        applicablePropInst = true;
                    } else {
                        for (VClass vclass : vclasses) {
                            if (vclass.getURI() == null || !vclass.getURI().equals(fauxSubpropertyKey.getDomainUri())) continue;
                            applicablePropInst = true;
                            break;
                        }
                    }
                    if (!applicablePropInst) continue;
                    propInsts.add(this.getPropInst(op, ResourceFactory.createResource((String)fauxSubpropertyKey.getDomainUri()), ResourceFactory.createResource((String)fauxSubpropertyKey.getRangeUri())));
                }
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        List<ObjectProperty> stragglers = this.getAdditionalFauxSubpropertiesForVClasses(vclasses, propInsts);
        for (ObjectProperty op : stragglers) {
            if (op == null) continue;
            propInsts.add(this.makePropInst(op));
        }
        return propInsts;
    }

    private PropertyInstance makePropInst(ObjectProperty op) {
        PropertyInstance pi = new PropertyInstance();
        pi.setDomainClassURI(op.getDomainVClassURI());
        pi.setRangeClassURI(op.getRangeVClassURI());
        pi.setSubjectSide(true);
        pi.setPropertyURI(op.getURI());
        pi.setPropertyName(op.getLabel());
        pi.setDomainPublic(op.getDomainPublic());
        return pi;
    }

    private PropertyInstance getPropInst(OntProperty op, Resource domainRes, Resource rangeRes) {
        String domainURIStr;
        if (log.isDebugEnabled() && domainRes != null && rangeRes != null) {
            log.debug((Object)("getPropInst() op: " + op.getURI() + " domain: " + domainRes.getURI() + " range: " + rangeRes.getURI()));
        }
        PropertyInstance pi = new PropertyInstance();
        String string = domainURIStr = domainRes != null && !domainRes.isAnon() ? (domainURIStr = domainRes.getURI()) : null;
        if (rangeRes != null) {
            String rangeClassURI = rangeRes.isAnon() ? this.PSEUDO_BNODE_NS + rangeRes.getId().toString() : rangeRes.getURI();
            pi.setRangeClassURI(rangeClassURI);
            VClass range = this.getWebappDaoFactory().getVClassDao().getVClassByURI(rangeClassURI);
            if (range == null) {
                range = new VClass();
                range.setURI(rangeClassURI);
                range.setName(range.getLocalName());
            }
            pi.setRangeClassName(range.getName());
        }
        pi.setDomainClassURI(domainURIStr);
        if (domainURIStr != null) {
            VClass domain = this.getWebappDaoFactory().getVClassDao().getVClassByURI(domainURIStr);
            if (domain == null) {
                domain = new VClass();
                domain.setURI(domainURIStr);
                domain.setName(domain.getLocalName());
            }
            pi.setDomainClassName(domain.getName());
        }
        pi.setSubjectSide(true);
        pi.setPropertyURI(op.getURI());
        pi.setPropertyName(this.getLabelOrId((OntResource)op));
        pi.setRangePublic(this.getLabelOrId((OntResource)op));
        pi.setDomainPublic(this.getLabelOrId((OntResource)op));
        return pi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ObjectProperty> getAdditionalFauxSubpropertiesForVClasses(List<VClass> vclasses, List<PropertyInstance> propInsts) {
        ArrayList<ObjectProperty> opList = new ArrayList<ObjectProperty>();
        if (vclasses.size() == 0) {
            return opList;
        }
        ObjectPropertyDao opDao = this.getWebappDaoFactory().getObjectPropertyDao();
        StringBuilder propQuery = new StringBuilder("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX config: <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#> \nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT ?property ?domain ?range WHERE { \n    ?context config:configContextFor ?property . \n    ?context config:qualifiedByDomain ?domain . \n    ?context config:qualifiedBy ?range . \n");
        for (PropertyInstance propInst : propInsts) {
            propQuery.append("    FILTER (?property != <").append(propInst.getPropertyURI()).append("> ) \n");
        }
        Iterator<VClass> classIt = vclasses.iterator();
        if (classIt.hasNext()) {
            propQuery.append("    FILTER ( \n");
            propQuery.append("        (?domain = <").append(OWL.Thing.getURI()).append("> )\n");
            while (classIt.hasNext()) {
                VClass vclass = classIt.next();
                if (vclass.isAnonymous()) continue;
                propQuery.append("       || (?domain = <").append(vclass.getURI()).append("> ) \n");
            }
            propQuery.append(") \n");
        }
        propQuery.append("} \n");
        log.debug((Object)propQuery.toString());
        Query q = QueryFactory.create((String)propQuery.toString());
        try (QueryExecution qe = QueryExecutionFactory.create((Query)q, (Model)this.getOntModelSelector().getDisplayModel());){
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution qsoln = rs.nextSolution();
                String propertyURI = qsoln.getResource("property").getURI();
                String domainURI = qsoln.getResource("domain").getURI();
                String rangeURI = qsoln.getResource("range").getURI();
                opList.add(opDao.getObjectPropertyByURIs(propertyURI, domainURI, rangeURI, null));
            }
        }
        return opList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PropertyDao.FullPropertyKey> getAdditionalFauxSubpropertyKeysForPropertyURI(String propertyURI) {
        ArrayList<PropertyDao.FullPropertyKey> keys = new ArrayList<PropertyDao.FullPropertyKey>();
        String propQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX config: <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#> \nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT ?domain ?range WHERE { \n    ?context config:configContextFor <" + propertyURI + "> . \n    ?context config:qualifiedBy ?range . \n    OPTIONAL { ?context config:qualifiedByDomain ?domain } \n}";
        Query q = QueryFactory.create((String)propQuery);
        try (QueryExecution qe = QueryExecutionFactory.create((Query)q, (Model)this.getOntModelSelector().getDisplayModel());){
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution qsoln = rs.nextSolution();
                Resource rangeRes = qsoln.getResource("range");
                String rangeURI = rangeRes.getURI();
                Resource domainRes = qsoln.getResource("domain");
                String domainURI = null;
                if (domainRes != null && !domainRes.isAnon()) {
                    domainURI = domainRes.getURI();
                }
                keys.add(new PropertyDao.FullPropertyKey(domainURI, propertyURI, rangeURI));
            }
        }
        return keys;
    }

    static {
        StringBuilder prefixes = new StringBuilder();
        for (String key : NAMESPACES.keySet()) {
            prefixes.append("PREFIX ").append(key).append(": <").append(NAMESPACES.get(key)).append(">\n");
        }
        PREFIXES = prefixes.toString();
        log.debug((Object)("Query prefixes: " + PREFIXES));
    }
}

