/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.dao.jena.BlankNodeFilteringGraph;
import edu.cornell.mannlib.vitro.webapp.dao.jena.BlankNodeStatementListener;
import edu.cornell.mannlib.vitro.webapp.modelaccess.adapters.AbstractModelMakerDecorator;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.ModelMaker;
import org.apache.jena.rdf.model.ModelReader;
import org.apache.jena.shared.CannotCreateException;

public class BlankNodeFilteringModelMaker
extends AbstractModelMakerDecorator {
    private static final Log log = LogFactory.getLog(BlankNodeFilteringModelMaker.class);
    private final RDFService rdfService;

    public BlankNodeFilteringModelMaker(RDFService rdfService, ModelMaker inner) {
        super(inner);
        this.rdfService = rdfService;
    }

    @Override
    public Model createModel(String name) {
        return this.wrapModelWithFilter(name, super.createModel(name));
    }

    @Override
    public Model createModel(String name, boolean strict) {
        return this.wrapModelWithFilter(name, super.createModel(name, strict));
    }

    @Override
    public Model openModel(String name) {
        return this.wrapModelWithFilter(name, super.openModel(name));
    }

    @Override
    public Model openModelIfPresent(String name) {
        return this.wrapModelWithFilter(name, super.openModelIfPresent(name));
    }

    @Override
    public Model getModel(String name) {
        return this.wrapModelWithFilter(name, super.getModel(name));
    }

    @Override
    public Model getModel(String name, ModelReader loadIfAbsent) {
        return this.wrapModelWithFilter(name, super.getModel(name, loadIfAbsent));
    }

    @Override
    public Model openModel(String name, boolean strict) {
        return this.wrapModelWithFilter(name, super.openModel(name, strict));
    }

    public Model wrapModelWithFilter(String name, Model model) {
        if (model == null) {
            return null;
        }
        String bnodeQuery = String.format("construct { ?s ?p ?o } \nwhere {  \n  graph <%s> { \n    ?s ?p ?o \n     filter (isBlank(?s) || isBlank(?o)) \n  } \n}", name);
        Model bnodeModel = ModelFactory.createDefaultModel();
        long start = System.currentTimeMillis();
        try {
            bnodeModel.read(this.rdfService.sparqlConstructQuery(bnodeQuery, RDFService.ModelSerializationFormat.N3), null, "N3");
            log.debug((Object)("constructed a model of blank nodes of size: " + bnodeModel.size() + " for graph " + name));
        }
        catch (Exception e) {
            log.error((Object)"error trying to create a blank node model: ", (Throwable)e);
            throw new CannotCreateException(name);
        }
        long timeElapsedMillis = System.currentTimeMillis() - start;
        log.debug((Object)("msecs to find blank nodes for graph " + name + " " + timeElapsedMillis));
        BlankNodeFilteringGraph bnodeFilteringGraph = new BlankNodeFilteringGraph(model.getGraph());
        Model bnodeFilteringModel = ModelFactory.createModelForGraph((Graph)bnodeFilteringGraph);
        Model specialUnionModel = VitroModelFactory.createUnion(bnodeFilteringModel, bnodeModel);
        bnodeFilteringModel.register((ModelChangedListener)new BlankNodeStatementListener(bnodeModel));
        return specialUnionModel;
    }
}

