/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering.filters;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.RequestIdentifiers;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasPermission;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.DisplayByRolePermission;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.Permission;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.PermissionRegistry;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayDataProperty;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayObjectProperty;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.display.DisplayObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFiltersImpl;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.sf.jga.fn.UnaryFunctor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilterByRoleLevelPermission
extends VitroFiltersImpl {
    private static final Log log = LogFactory.getLog(FilterByRoleLevelPermission.class);
    private final Permission permission;

    private static Permission getDefaultPermission(ServletContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("context may not be null.");
        }
        return PermissionRegistry.getRegistry(ctx).getPermission(DisplayByRolePermission.NAMESPACE + "Public");
    }

    private static Permission getPermissionFromRequest(HttpServletRequest req) {
        if (req == null) {
            throw new NullPointerException("request may not be null.");
        }
        IdentifierBundle ids = RequestIdentifiers.getIdBundleForRequest((ServletRequest)req);
        for (Permission p : HasPermission.getPermissions(ids)) {
            if (!(p instanceof DisplayByRolePermission)) continue;
            return p;
        }
        return FilterByRoleLevelPermission.getDefaultPermission(req.getSession().getServletContext());
    }

    public FilterByRoleLevelPermission(HttpServletRequest req) {
        this(FilterByRoleLevelPermission.getPermissionFromRequest(req));
    }

    public FilterByRoleLevelPermission(ServletContext ctx) {
        this(FilterByRoleLevelPermission.getDefaultPermission(ctx));
    }

    public FilterByRoleLevelPermission(Permission permission) {
        if (permission == null) {
            throw new NullPointerException("permission may not be null.");
        }
        this.permission = permission;
        this.setDataPropertyFilter(new DataPropertyFilterByPolicy());
        this.setObjectPropertyFilter(new ObjectPropertyFilterByPolicy());
        this.setDataPropertyStatementFilter(new DataPropertyStatementFilterByPolicy());
        this.setObjectPropertyStatementFilter(new ObjectPropertyStatementFilterByPolicy());
    }

    boolean checkAuthorization(RequestedAction whatToAuth) {
        boolean decision = this.permission.isAuthorized(whatToAuth);
        log.debug((Object)("decision is " + decision));
        return decision;
    }

    private class ObjectPropertyStatementFilterByPolicy
    extends UnaryFunctor<ObjectPropertyStatement, Boolean> {
        private ObjectPropertyStatementFilterByPolicy() {
        }

        public Boolean fn(ObjectPropertyStatement ops) {
            String subjectUri = ops.getSubjectURI();
            ObjectProperty predicate = this.getOrCreateProperty(ops);
            String objectUri = ops.getObjectURI();
            return FilterByRoleLevelPermission.this.checkAuthorization(new DisplayObjectPropertyStatement(subjectUri, predicate, objectUri));
        }

        private ObjectProperty getOrCreateProperty(ObjectPropertyStatement ops) {
            if (ops.getProperty() != null) {
                return ops.getProperty();
            }
            if (ops.getPropertyURI() == null) {
                return null;
            }
            ObjectProperty op = new ObjectProperty();
            op.setURI(ops.getPropertyURI());
            op.setDomainVClassURI(RequestedAction.SOME_URI);
            op.setRangeVClassURI(RequestedAction.SOME_URI);
            return op;
        }
    }

    private class DataPropertyStatementFilterByPolicy
    extends UnaryFunctor<DataPropertyStatement, Boolean> {
        private DataPropertyStatementFilterByPolicy() {
        }

        public Boolean fn(DataPropertyStatement dps) {
            return FilterByRoleLevelPermission.this.checkAuthorization(new DisplayDataPropertyStatement(dps));
        }
    }

    private class ObjectPropertyFilterByPolicy
    extends UnaryFunctor<ObjectProperty, Boolean> {
        private ObjectPropertyFilterByPolicy() {
        }

        public Boolean fn(ObjectProperty op) {
            return FilterByRoleLevelPermission.this.checkAuthorization(new DisplayObjectProperty(op));
        }
    }

    private class DataPropertyFilterByPolicy
    extends UnaryFunctor<DataProperty, Boolean> {
        private DataPropertyFilterByPolicy() {
        }

        public Boolean fn(DataProperty dp) {
            return FilterByRoleLevelPermission.this.checkAuthorization(new DisplayDataProperty(dp));
        }
    }
}

