/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.filtering;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.BaseFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.ObjectPropertyFiltering;
import edu.cornell.mannlib.vitro.webapp.dao.filtering.filters.VitroFilters;
import java.util.LinkedList;
import java.util.List;
import net.sf.jga.algorithms.Filter;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.fn.adaptor.AndUnary;

public class ObjectPropertyDaoFiltering
extends BaseFiltering
implements ObjectPropertyDao {
    final ObjectPropertyDao innerObjectPropertyDao;
    final VitroFilters filters;
    private static final UnaryFunctor<ObjectProperty, Boolean> notNull = new UnaryFunctor<ObjectProperty, Boolean>(){

        public Boolean fn(ObjectProperty arg) {
            return arg != null;
        }
    };

    public ObjectPropertyDaoFiltering(ObjectPropertyDao objectPropertyDao, VitroFilters filters) {
        this.innerObjectPropertyDao = objectPropertyDao;
        this.filters = filters;
    }

    public List getAllObjectProperties() {
        return ObjectPropertyDaoFiltering.filterAndWrap(this.innerObjectPropertyDao.getAllObjectProperties(), this.filters);
    }

    public List getObjectPropertiesForObjectPropertyStatements(List<ObjectPropertyStatement> objectPropertyStatements) {
        List<ObjectProperty> list = this.innerObjectPropertyDao.getObjectPropertiesForObjectPropertyStatements(objectPropertyStatements);
        return ObjectPropertyDaoFiltering.filterAndWrap(list, this.filters);
    }

    @Override
    public ObjectProperty getObjectPropertyByURI(String objectPropertyURI) {
        ObjectProperty newOprop = this.innerObjectPropertyDao.getObjectPropertyByURI(objectPropertyURI);
        return newOprop == null ? null : new ObjectPropertyFiltering(newOprop, this.filters);
    }

    @Override
    public ObjectProperty getObjectPropertyByURIs(String objectPropertyURI, String domainURI, String rangeURI) {
        ObjectProperty newOprop = this.innerObjectPropertyDao.getObjectPropertyByURIs(objectPropertyURI, domainURI, rangeURI);
        return newOprop == null ? null : new ObjectPropertyFiltering(newOprop, this.filters);
    }

    @Override
    public ObjectProperty getObjectPropertyByURIs(String objectPropertyURI, String domainURI, String rangeURI, ObjectProperty base) {
        ObjectProperty newOprop = this.innerObjectPropertyDao.getObjectPropertyByURIs(objectPropertyURI, domainURI, rangeURI, base);
        return newOprop == null ? null : new ObjectPropertyFiltering(newOprop, this.filters);
    }

    public List getRootObjectProperties() {
        return ObjectPropertyDaoFiltering.filterAndWrap(this.innerObjectPropertyDao.getRootObjectProperties(), this.filters);
    }

    @Override
    public void deleteObjectProperty(String objectPropertyURI) {
        this.innerObjectPropertyDao.deleteObjectProperty(objectPropertyURI);
    }

    @Override
    public void deleteObjectProperty(ObjectProperty objectProperty) {
        this.innerObjectPropertyDao.deleteObjectProperty(objectProperty);
    }

    @Override
    public void fillObjectPropertiesForIndividual(Individual individual) {
        this.innerObjectPropertyDao.fillObjectPropertiesForIndividual(individual);
    }

    @Override
    public int insertObjectProperty(ObjectProperty objectProperty) throws InsertException {
        return this.innerObjectPropertyDao.insertObjectProperty(objectProperty);
    }

    @Override
    public void updateObjectProperty(ObjectProperty objectProperty) {
        this.innerObjectPropertyDao.updateObjectProperty(objectProperty);
    }

    public void addSuperproperty(ObjectProperty property, ObjectProperty superproperty) {
        this.innerObjectPropertyDao.addSuperproperty(property, superproperty);
    }

    @Override
    public void addSuperproperty(String propertyURI, String superpropertyURI) {
        this.innerObjectPropertyDao.addSuperproperty(propertyURI, superpropertyURI);
    }

    public void removeSuperproperty(ObjectProperty property, ObjectProperty superproperty) {
        this.innerObjectPropertyDao.removeSuperproperty(property, superproperty);
    }

    @Override
    public void removeSuperproperty(String propertyURI, String superpropertyURI) {
        this.innerObjectPropertyDao.removeSuperproperty(propertyURI, superpropertyURI);
    }

    public void addSubproperty(ObjectProperty property, ObjectProperty subproperty) {
        this.innerObjectPropertyDao.addSubproperty(property, subproperty);
    }

    @Override
    public void addSubproperty(String propertyURI, String subpropertyURI) {
        this.innerObjectPropertyDao.addSubproperty(propertyURI, subpropertyURI);
    }

    public void removeSubproperty(ObjectProperty property, ObjectProperty subproperty) {
        this.innerObjectPropertyDao.removeSubproperty(property, subproperty);
    }

    @Override
    public void removeSubproperty(String propertyURI, String subpropertyURI) {
        this.innerObjectPropertyDao.removeSubproperty(propertyURI, subpropertyURI);
    }

    @Override
    public List<String> getSubPropertyURIs(String propertyURI) {
        return this.innerObjectPropertyDao.getSubPropertyURIs(propertyURI);
    }

    @Override
    public List<String> getAllSubPropertyURIs(String propertyURI) {
        return this.innerObjectPropertyDao.getAllSubPropertyURIs(propertyURI);
    }

    @Override
    public List<String> getSuperPropertyURIs(String propertyURI, boolean direct) {
        return this.innerObjectPropertyDao.getSuperPropertyURIs(propertyURI, direct);
    }

    @Override
    public List<String> getAllSuperPropertyURIs(String propertyURI) {
        return this.innerObjectPropertyDao.getAllSuperPropertyURIs(propertyURI);
    }

    public static List<ObjectProperty> filterAndWrap(List<ObjectProperty> list, VitroFilters filters) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return list;
        }
        LinkedList filtered = new LinkedList();
        Filter.filter(list, (UnaryFunctor)new AndUnary(notNull, filters.getObjectPropertyFilter()), filtered);
        LinkedList<ObjectProperty> wrapped = new LinkedList<ObjectProperty>();
        for (ObjectProperty prop : filtered) {
            if (prop == null) continue;
            wrapped.add(new ObjectPropertyFiltering(prop, filters));
        }
        return wrapped;
    }

    @Override
    public void addSubproperty(Property property, Property subproperty) {
        this.innerObjectPropertyDao.addSubproperty(property, subproperty);
    }

    @Override
    public void addSuperproperty(Property property, Property superproperty) {
        this.innerObjectPropertyDao.addSuperproperty(property, superproperty);
    }

    @Override
    public void removeSubproperty(Property property, Property subproperty) {
        this.innerObjectPropertyDao.removeSubproperty(property, subproperty);
    }

    @Override
    public void removeSuperproperty(Property property, Property superproperty) {
        this.innerObjectPropertyDao.removeSuperproperty(property, superproperty);
    }

    @Override
    public void addEquivalentProperty(String propertyURI, String equivalentPropertyURI) {
        this.innerObjectPropertyDao.addEquivalentProperty(propertyURI, equivalentPropertyURI);
    }

    @Override
    public void addEquivalentProperty(Property property, Property equivalentProperty) {
        this.innerObjectPropertyDao.addEquivalentProperty(property, equivalentProperty);
    }

    @Override
    public List<String> getEquivalentPropertyURIs(String propertyURI) {
        return this.innerObjectPropertyDao.getEquivalentPropertyURIs(propertyURI);
    }

    @Override
    public void removeEquivalentProperty(String propertyURI, String equivalentPropertyURI) {
        this.innerObjectPropertyDao.removeEquivalentProperty(propertyURI, equivalentPropertyURI);
    }

    @Override
    public void removeEquivalentProperty(Property property, Property equivalentProperty) {
        this.innerObjectPropertyDao.removeEquivalentProperty(property, equivalentProperty);
    }

    @Override
    public boolean skipEditForm(String predicateURI) {
        return this.innerObjectPropertyDao.skipEditForm(predicateURI);
    }

    @Override
    public List<VClass> getClassesWithRestrictionOnProperty(String propertyURI) {
        return this.innerObjectPropertyDao.getClassesWithRestrictionOnProperty(propertyURI);
    }

    @Override
    public List<ObjectProperty> getObjectPropertyList(Individual subject) {
        return this.innerObjectPropertyDao.getObjectPropertyList(subject);
    }

    @Override
    public List<ObjectProperty> getObjectPropertyList(String subjectUri) {
        return this.innerObjectPropertyDao.getObjectPropertyList(subjectUri);
    }

    @Override
    public String getCustomListViewConfigFileName(ObjectProperty objectProperty) {
        return this.innerObjectPropertyDao.getCustomListViewConfigFileName(objectProperty);
    }
}

