/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.grefine;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocumentList;
import edu.cornell.mannlib.vitro.webapp.utils.json.JacksonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="JSON Reconcile Service", urlPatterns={"/reconcile"})
public class JSONReconcileServlet
extends VitroHttpServlet {
    private static final String INTERNAL_QUERY_NAME = "A0B1C2";
    private static final String PARAM_QUERY = "term";
    private static final long serialVersionUID = 1L;
    private static String QUERY_PARAMETER_NAME = "term";
    private static final String PARAM_RDFTYPE = "type";
    public static final int MAX_QUERY_LENGTH = 500;
    private static final int DEFAULT_MAX_HIT_COUNT = 1000;
    private static final Log log = LogFactory.getLog((String)JSONReconcileServlet.class.getName());

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
        resp.setContentType("application/json");
        VitroRequest vreq = new VitroRequest(req);
        try {
            if (vreq.getParameter("query") != null || vreq.getParameter("queries") != null) {
                ObjectNode qJson = this.getResult(vreq, req, resp);
                log.debug((Object)("result: " + qJson.toString()));
                String responseStr = vreq.getParameter("callback") == null ? qJson.toString() : vreq.getParameter("callback") + "(" + qJson.toString() + ")";
                ServletOutputStream out = resp.getOutputStream();
                out.print(responseStr);
            } else {
                String defaultNamespace = null;
                String defaultTypeList = null;
                String serverName = null;
                int serverPort = req.getServerPort();
                if (vreq.getWebappDaoFactory() != null) {
                    defaultNamespace = vreq.getWebappDaoFactory().getDefaultNamespace();
                }
                defaultTypeList = ConfigurationProperties.getBean((ServletRequest)req).getProperty("Vitro.reconcile.defaultTypeList");
                serverName = req.getServerName();
                ObjectNode metaJson = this.getMetadata(req, resp, defaultNamespace, defaultTypeList, serverName, serverPort);
                String callbackStr = vreq.getParameter("callback") == null ? "" : vreq.getParameter("callback");
                ServletOutputStream out = resp.getOutputStream();
                out.print(callbackStr + "(" + metaJson.toString() + ")");
            }
        }
        catch (Exception ex) {
            log.warn((Object)ex, (Throwable)ex);
        }
    }

    private ObjectNode getResult(VitroRequest vreq, HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        Object qStr;
        HashMap<String, JsonNode> searchWithTypeMap = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> searchNoTypeMap = new HashMap<String, JsonNode>();
        ArrayList<Object> queries = new ArrayList<Object>();
        String qObj = vreq.getParameter("queries");
        if (qObj == null && (qObj = vreq.getParameter("query")) instanceof String && !qObj.contains("{")) {
            qObj = "{ \"query\" : \"" + qObj + "\" }";
        }
        if (qObj != null && qObj instanceof String) {
            qStr = qObj;
            queries.add(qStr);
            log.debug((Object)("\nquery: " + (String)qStr + "\n"));
        }
        try {
            qStr = queries.iterator();
            while (qStr.hasNext()) {
                ObjectMapper mapper = new ObjectMapper();
                String queryStr = (String)qStr.next();
                JsonNode json = mapper.readTree(queryStr);
                if (json.has("query")) {
                    if (json.has(PARAM_RDFTYPE)) {
                        searchWithTypeMap.put(INTERNAL_QUERY_NAME, json);
                        continue;
                    }
                    searchNoTypeMap.put(INTERNAL_QUERY_NAME, json);
                    continue;
                }
                Iterator iter = json.fieldNames();
                while (iter.hasNext()) {
                    ArrayList jsonList = new ArrayList();
                    String key = (String)iter.next();
                    JsonNode jsonLvl2 = json.get(key);
                    if (!jsonLvl2.has("query")) continue;
                    if (jsonLvl2.has(PARAM_RDFTYPE)) {
                        searchWithTypeMap.put(key, jsonLvl2);
                        continue;
                    }
                    searchNoTypeMap.put(key, jsonLvl2);
                }
            }
        }
        catch (IOException ex) {
            log.error((Object)("JSONException: " + ex));
            throw new ServletException("JSONReconcileServlet JSONException: " + ex);
        }
        ObjectNode qJson = null;
        qJson = searchWithTypeMap.size() > 0 ? this.runSearch(searchWithTypeMap) : this.runSearch(searchNoTypeMap);
        return qJson;
    }

    protected ObjectNode getMetadata(HttpServletRequest req, HttpServletResponse resp, String defaultNamespace, String defaultTypeList, String serverName, int serverPort) throws ServletException {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        json.put("name", "VIVO Reconciliation Service");
        if (defaultNamespace != null) {
            json.put("identifierSpace", defaultNamespace);
            json.put("schemaSpace", defaultNamespace);
        }
        ObjectNode viewJson = JsonNodeFactory.instance.objectNode();
        StringBuilder urlBuf = new StringBuilder();
        urlBuf.append("http://").append(serverName);
        if (serverPort == 8080) {
            urlBuf.append(":").append(serverPort);
        }
        if (req.getContextPath() != null) {
            urlBuf.append(req.getContextPath());
        }
        viewJson.put("url", urlBuf.toString() + "/individual?uri={{id}}");
        json.put("view", (JsonNode)viewJson);
        if (defaultTypeList != null) {
            String[] splitList = defaultTypeList.split(";");
            String[][] idNameArray = new String[splitList.length][splitList.length];
            for (int i = 0; i < splitList.length; ++i) {
                idNameArray[i] = splitList[i].split(",");
            }
            ArrayNode defaultTypesJsonArr = JsonNodeFactory.instance.arrayNode();
            for (String[] anIdNameArray : idNameArray) {
                ObjectNode defaultTypesJson = JsonNodeFactory.instance.objectNode();
                defaultTypesJson.put("id", anIdNameArray[0].trim());
                defaultTypesJson.put("name", anIdNameArray[1].trim());
                defaultTypesJsonArr.add((JsonNode)defaultTypesJson);
            }
            json.put("defaultTypes", (JsonNode)defaultTypesJsonArr);
        }
        return json;
    }

    private ObjectNode runSearch(HashMap<String, JsonNode> currMap) throws ServletException {
        ObjectNode qJson = JsonNodeFactory.instance.objectNode();
        try {
            for (Map.Entry<String, JsonNode> entry : currMap.entrySet()) {
                JsonNode propertiesNode;
                ObjectNode resultAllJson = JsonNodeFactory.instance.objectNode();
                String key = entry.getKey();
                JsonNode json = entry.getValue();
                String queryVal = json.get("query").asText();
                String searchType = null;
                int limit = 10;
                String typeStrict = "should";
                ArrayList<String[]> propertiesList = new ArrayList<String[]>();
                if (json.has(PARAM_RDFTYPE)) {
                    searchType = json.get(PARAM_RDFTYPE).asText();
                }
                if (json.has("limit")) {
                    limit = json.get("limit").asInt();
                }
                if (json.has("type_strict")) {
                    typeStrict = json.get("type_strict").asText();
                }
                if (json.has("properties") && (propertiesNode = json.get("properties")) instanceof ArrayNode) {
                    ArrayNode properties = (ArrayNode)propertiesNode;
                    for (int i = 0; i < properties.size(); ++i) {
                        String[] pvPair = new String[2];
                        JsonNode jsonProperty = properties.get(i);
                        String pid = JacksonUtils.getString(jsonProperty, "pid");
                        String v = JacksonUtils.getString(jsonProperty, "v");
                        if (pid == null || v == null) continue;
                        pvPair[0] = pid;
                        pvPair[1] = v;
                        propertiesList.add(pvPair);
                    }
                }
                ArrayNode resultJsonArr = JsonNodeFactory.instance.arrayNode();
                SearchQuery query = this.getQuery(queryVal, searchType, limit, propertiesList);
                SearchResponse queryResponse = null;
                if (query != null) {
                    SearchEngine search = ApplicationUtils.instance().getSearchEngine();
                    queryResponse = search.query(query);
                } else {
                    log.error((Object)"Query for a search was null");
                }
                SearchResultDocumentList docs = null;
                if (queryResponse != null) {
                    docs = queryResponse.getResults();
                } else {
                    log.error((Object)"Query response for a search was null");
                }
                if (docs != null) {
                    ArrayList results = new ArrayList();
                    for (SearchResultDocument doc : docs) {
                        try {
                            String uri = doc.getStringValue("URI");
                            String name = doc.getStringValue("nameRaw");
                            SearchResult result = new SearchResult(name, uri);
                            ObjectNode resultJson = JsonNodeFactory.instance.objectNode();
                            Object score = doc.getFirstValue("score");
                            if (score instanceof Double) {
                                resultJson.put("score", (Double)score);
                            } else if (score instanceof Float) {
                                resultJson.put("score", (Float)score);
                            }
                            String modUri = result.getUri().replace("#", "%23");
                            resultJson.put("id", modUri);
                            resultJson.put("name", result.getLabel());
                            Collection<Object> rdfTypes = doc.getFieldValues(PARAM_RDFTYPE);
                            ArrayNode typesJsonArr = JsonNodeFactory.instance.arrayNode();
                            if (rdfTypes != null) {
                                for (Object rdfType : rdfTypes) {
                                    String type = (String)rdfType;
                                    int lastIndex2 = type.lastIndexOf(47) + 1;
                                    String typeName = type.substring(lastIndex2);
                                    typeName = typeName.replace("#", ":");
                                    ObjectNode typesJson = JsonNodeFactory.instance.objectNode();
                                    typesJson.put("id", type);
                                    typesJson.put("name", typeName);
                                    typesJsonArr.add((JsonNode)typesJson);
                                }
                            }
                            resultJson.put(PARAM_RDFTYPE, (JsonNode)typesJsonArr);
                            resultJson.put("match", false);
                            resultJsonArr.add((JsonNode)resultJson);
                        }
                        catch (Exception e) {
                            log.error((Object)("problem getting usable individuals from search hits" + e.getMessage()));
                        }
                    }
                } else {
                    log.error((Object)"Docs for a search was null");
                }
                resultAllJson.put("result", (JsonNode)resultJsonArr);
                qJson.put(key, (JsonNode)resultAllJson);
            }
        }
        catch (SearchEngineException ex) {
            log.error((Object)("JSONException: " + ex));
            throw new ServletException("JSONReconcileServlet SearchEngineException: " + ex);
        }
        if (qJson.has(INTERNAL_QUERY_NAME)) {
            return (ObjectNode)qJson.get(INTERNAL_QUERY_NAME);
        }
        return qJson;
    }

    protected SearchQuery getQuery(String queryStr, String searchType, int limit, ArrayList<String[]> propertiesList) {
        if (queryStr == null) {
            log.error((Object)"There was no parameter 'term' in the request.");
            return null;
        }
        if (queryStr.length() > 500) {
            log.debug((Object)"The search was too long. The maximum query length is 500");
            return null;
        }
        SearchQuery query = ApplicationUtils.instance().getSearchEngine().createQuery(queryStr.toLowerCase());
        query.setStart(0).setRows(limit);
        if (searchType != null) {
            query.addFilterQuery("type:\"" + searchType + "\"");
        }
        query.addFields("nameRaw", "URI", "*", "score");
        for (String[] pvPair : propertiesList) {
            query.addFilterQueries(this.tokenizeNameQuery(pvPair[1]), "type:\"" + pvPair[0] + "\"");
        }
        return query;
    }

    private String tokenizeNameQuery(String queryStr) {
        String acQueryStr;
        String acTermName = "acNameStemmed";
        String nonAcTermName = "nameStemmed";
        if (queryStr.endsWith(" ")) {
            acQueryStr = this.makeTermQuery(nonAcTermName, queryStr, true);
        } else {
            String lastWord;
            int indexOfLastWord = queryStr.lastIndexOf(" ") + 1;
            ArrayList<String> terms = new ArrayList<String>(2);
            String allButLastWord = queryStr.substring(0, indexOfLastWord);
            if (StringUtils.isNotBlank((CharSequence)allButLastWord)) {
                terms.add(this.makeTermQuery(nonAcTermName, allButLastWord, true));
            }
            if (StringUtils.isNotBlank((CharSequence)(lastWord = queryStr.substring(indexOfLastWord)))) {
                terms.add(this.makeTermQuery(acTermName, lastWord, false));
            }
            acQueryStr = StringUtils.join(terms, (String)" AND ");
        }
        log.debug((Object)("Tokenized name query string = " + acQueryStr));
        return acQueryStr;
    }

    private String makeTermQuery(String term, String queryStr, boolean mayContainWhitespace) {
        if (mayContainWhitespace) {
            queryStr = "\"" + this.escapeWhitespaceInQueryString(queryStr) + "\"";
        }
        return term + ":" + queryStr;
    }

    private String escapeWhitespaceInQueryString(String queryStr) {
        return queryStr.replaceAll("\\s+", "\\\\ ");
    }

    public class SearchResult
    implements Comparable<SearchResult> {
        private String label;
        private String uri;

        SearchResult(String label, String uri) {
            this.label = label;
            this.uri = uri;
        }

        public String getLabel() {
            return this.label;
        }

        public String getUri() {
            return this.uri;
        }

        Map<String, String> toMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("label", this.label);
            map.put("uri", this.uri);
            return map;
        }

        @Override
        public int compareTo(SearchResult o) throws ClassCastException {
            if (!(o instanceof SearchResult)) {
                throw new ClassCastException("Error in SearchResult.compareTo(): expected SearchResult object.");
            }
            SearchResult sr = o;
            return this.label.compareToIgnoreCase(sr.getLabel());
        }
    }
}

