/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.grefine;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyStatementDao;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Literal;

@WebServlet(name="Google Refine Mqlread Service", urlPatterns={"/grefineMqlread"})
public class GrefineMqlreadServlet
extends VitroHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((String)GrefineMqlreadServlet.class.getName());

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
        resp.setContentType("application/json");
        VitroRequest vreq = new VitroRequest(req);
        try {
            if (vreq.getParameter("query") != null) {
                ObjectNode qJson = this.getResult(vreq, req, resp);
                log.debug((Object)("result: " + qJson.toString()));
                String responseStr = vreq.getParameter("callback") == null ? qJson.toString() : vreq.getParameter("callback") + "(" + qJson.toString() + ")";
                ServletOutputStream out = resp.getOutputStream();
                out.print(responseStr);
            }
        }
        catch (Exception ex) {
            log.warn((Object)ex, (Throwable)ex);
        }
    }

    private ObjectNode getResult(VitroRequest vreq, HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        ObjectNode resultAllJson = JsonNodeFactory.instance.objectNode();
        ArrayList<String> subjectUriList = new ArrayList<String>();
        HashMap<String, ArrayNode> propertyUriMap = new HashMap<String, ArrayNode>();
        String query = vreq.getParameter("query");
        this.parseQuery(query, subjectUriList, propertyUriMap);
        ArrayNode resultAllJsonArr = JsonNodeFactory.instance.arrayNode();
        DataPropertyStatementDao dpsDao = vreq.getUnfilteredWebappDaoFactory().getDataPropertyStatementDao();
        for (String subjectUri : subjectUriList) {
            ObjectNode subjectPropertyResultJson = JsonNodeFactory.instance.objectNode();
            subjectPropertyResultJson.put("id", subjectUri);
            for (Map.Entry entry : propertyUriMap.entrySet()) {
                int limit = 200;
                String propertyUri = (String)entry.getKey();
                ArrayNode propertyUriOptions = (ArrayNode)entry.getValue();
                for (int i = 0; i < propertyUriOptions.size(); ++i) {
                    ObjectNode propertyUriOption = (ObjectNode)propertyUriOptions.get(i);
                    limit = propertyUriOption.get("limit").asInt();
                }
                List<Literal> literals = dpsDao.getDataPropertyValuesForIndividualByProperty(subjectUri, propertyUri);
                if (literals.size() <= 0) continue;
                int counter = 0;
                ArrayNode valueJsonArr = JsonNodeFactory.instance.arrayNode();
                for (Literal literal : literals) {
                    if (counter <= limit) {
                        String value = literal.getLexicalForm();
                        valueJsonArr.add(value);
                    }
                    ++counter;
                }
                subjectPropertyResultJson.put(propertyUri, (JsonNode)valueJsonArr);
            }
            resultAllJsonArr.add((JsonNode)subjectPropertyResultJson);
        }
        resultAllJson.put("result", (JsonNode)resultAllJsonArr);
        return resultAllJson;
    }

    private void parseQuery(String query, ArrayList<String> subjectUriList, Map<String, ArrayNode> propertyUriMap) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode rawJson = (ObjectNode)mapper.readTree(query);
            ArrayNode qJsonArr = (ArrayNode)rawJson.get("query");
            for (int i = 0; i < qJsonArr.size(); ++i) {
                JsonNode obj = qJsonArr.get(i);
                if (!(obj instanceof ObjectNode)) continue;
                ObjectNode jsonObj = (ObjectNode)obj;
                Iterator jsonObjNames = jsonObj.fieldNames();
                while (jsonObjNames.hasNext()) {
                    JsonNode subjectUriObj;
                    JsonNode propertyUriObj;
                    String objName = (String)jsonObjNames.next();
                    if (objName.contains("http://")) {
                        propertyUriObj = jsonObj.get(objName);
                        if (!(propertyUriObj instanceof ArrayNode)) continue;
                        propertyUriMap.put(objName, (ArrayNode)propertyUriObj);
                        continue;
                    }
                    if ("id".equals(objName)) {
                        propertyUriObj = jsonObj.get(objName);
                        continue;
                    }
                    if (!"id|=".equals(objName) || !((subjectUriObj = jsonObj.get(objName)) instanceof ArrayNode)) continue;
                    ArrayNode subjectUriUriArr = (ArrayNode)subjectUriObj;
                    for (int k = 0; k < subjectUriUriArr.size(); ++k) {
                        JsonNode subjectUriUriObj = subjectUriUriArr.get(k);
                        if (!(subjectUriUriObj instanceof String)) continue;
                        subjectUriList.add((String)subjectUriUriObj);
                    }
                }
            }
        }
        catch (IOException e) {
            log.error((Object)("GrefineMqlreadServlet parseQuery JSONException: " + e));
        }
    }
}

