/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.authenticate;

import edu.cornell.mannlib.vitro.webapp.controller.authenticate.BaseLoginServlet;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.ExternalAuthHelper;
import edu.cornell.mannlib.vitro.webapp.controller.login.LoginProcessBean;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@WebServlet(name="loginExternalAuthSetup", urlPatterns={"/loginExternalAuth"})
public class LoginExternalAuthSetup
extends BaseLoginServlet {
    private static final Log log = LogFactory.getLog(LoginExternalAuthSetup.class);
    static final String ATTRIBUTE_REFERRER = LoginExternalAuthSetup.class.getName() + ".referrer";
    private static final String RETURN_SERVLET_URL = "/loginExternalAuthReturn";
    private static final String HEADING_REFERRER = "referer";

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.storeTheReferringPage(req);
        LoginProcessBean.getBean(req).setState(LoginProcessBean.State.LOGGING_IN);
        String returnUrl = this.buildReturnUrl(req);
        String redirectUrl = ExternalAuthHelper.getHelper((ServletRequest)req).buildExternalAuthRedirectUrl(returnUrl);
        if (redirectUrl == null) {
            this.complainAndReturnToReferrer(req, resp, ATTRIBUTE_REFERRER, LoginExternalAuthSetup.messageLoginFailed(req));
        }
        log.debug((Object)("redirecting to '" + redirectUrl + "'"));
        resp.sendRedirect(redirectUrl);
    }

    private void storeTheReferringPage(HttpServletRequest req) {
        String referrer = req.getHeader(HEADING_REFERRER);
        if (referrer == null) {
            this.dumpRequestHeaders(req);
            referrer = this.figureHomePageUrl(req);
        }
        log.debug((Object)("Referring page is '" + referrer + "'"));
        req.getSession().setAttribute(ATTRIBUTE_REFERRER, (Object)referrer);
    }

    private String buildReturnUrl(HttpServletRequest req) {
        return this.figureHomePageUrl(req) + RETURN_SERVLET_URL;
    }

    private void dumpRequestHeaders(HttpServletRequest req) {
        if (log.isDebugEnabled()) {
            Enumeration names = req.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                log.debug((Object)("header: " + name + "=" + req.getHeader(name)));
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }
}

