/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery;

import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.RdfResultMediaType;
import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.SparqlQueryApiExecutor;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.utils.http.AcceptHeaderParsingException;
import edu.cornell.mannlib.vitro.webapp.utils.http.ContentTypeUtil;
import edu.cornell.mannlib.vitro.webapp.utils.http.NotAcceptableException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.jena.rdf.model.Model;

abstract class SparqlQueryApiRdfProducer
extends SparqlQueryApiExecutor {
    protected final RdfResultMediaType mediaType;

    public SparqlQueryApiRdfProducer(RDFService rdfService, String queryString, String acceptHeader) throws AcceptHeaderParsingException, NotAcceptableException {
        super(rdfService, queryString);
        Collection<String> contentTypes = RdfResultMediaType.contentTypes();
        String bestType = ContentTypeUtil.bestContentType(acceptHeader, contentTypes);
        this.mediaType = RdfResultMediaType.fromContentType(bestType);
    }

    @Override
    public String getMediaType() {
        return this.mediaType.getContentType();
    }

    @Override
    public void executeAndFormat(OutputStream out) throws RDFServiceException, IOException {
        InputStream rawResult = this.getRawResultStream();
        if (this.mediaType.isNativeFormat()) {
            IOUtils.copy((InputStream)rawResult, (OutputStream)out);
        } else if (this.mediaType.getJenaResponseFormat().equals("JSON")) {
            this.parseToModel(rawResult).write(out, "JSON-LD");
        } else {
            this.parseToModel(rawResult).write(out, this.mediaType.getJenaResponseFormat());
        }
    }

    private Model parseToModel(InputStream rawResult) {
        RDFService.ModelSerializationFormat format = RDFService.ModelSerializationFormat.valueOf(this.mediaType.getSerializationFormat());
        return RDFServiceUtils.parseModel(rawResult, format);
    }

    protected abstract InputStream getRawResultStream() throws RDFServiceException;
}

