/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.user;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.SelfEditingConfiguration;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.admin.UserAccountsEditPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.user.UserAccountsMyAccountPageStrategy;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.web.images.PlaceholderUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserAccountsMyAccountPage
extends UserAccountsPage {
    private static final Log log = LogFactory.getLog(UserAccountsEditPage.class);
    private static final String PARAMETER_SUBMIT = "submitMyAccount";
    private static final String PARAMETER_EMAIL_ADDRESS = "emailAddress";
    private static final String PARAMETER_FIRST_NAME = "firstName";
    private static final String PARAMETER_LAST_NAME = "lastName";
    private static final String PARAMETER_PROXY_URI = "proxyUri";
    private static final String ERROR_NO_EMAIL = "errorEmailIsEmpty";
    private static final String ERROR_EMAIL_IN_USE = "errorEmailInUse";
    private static final String ERROR_EMAIL_INVALID_FORMAT = "errorEmailInvalidFormat";
    private static final String ERROR_NO_FIRST_NAME = "errorFirstNameIsEmpty";
    private static final String ERROR_NO_LAST_NAME = "errorLastNameIsEmpty";
    private static final String TEMPLATE_NAME = "userAccounts-myAccount.ftl";
    private static final String PROPERTY_PROFILE_TYPES = "proxy.eligibleTypeList";
    private final UserAccountsMyAccountPageStrategy strategy;
    private final UserAccount userAccount;
    private boolean submit;
    private String emailAddress = "";
    private String firstName = "";
    private String lastName = "";
    private List<String> proxyUris = new ArrayList<String>();
    private String errorCode = "";
    private String confirmationCode = "";

    public UserAccountsMyAccountPage(VitroRequest vreq) {
        super(vreq);
        this.userAccount = LoginStatusBean.getCurrentUser((HttpServletRequest)vreq);
        this.strategy = UserAccountsMyAccountPageStrategy.getInstance(vreq, this, this.isExternalAccount());
        this.parseRequestParameters();
        if (this.isSubmit()) {
            this.validateParameters();
        }
    }

    public UserAccount getUserAccount() {
        return this.userAccount;
    }

    private void parseRequestParameters() {
        this.submit = this.isFlagOnRequest(PARAMETER_SUBMIT);
        this.emailAddress = this.getStringParameter(PARAMETER_EMAIL_ADDRESS, "");
        this.firstName = this.getStringParameter(PARAMETER_FIRST_NAME, "");
        this.lastName = this.getStringParameter(PARAMETER_LAST_NAME, "");
        this.proxyUris = this.getStringParameters(PARAMETER_PROXY_URI);
        this.strategy.parseAdditionalParameters();
    }

    public boolean isSubmit() {
        return this.submit;
    }

    private void validateParameters() {
        this.errorCode = this.emailAddress.isEmpty() ? ERROR_NO_EMAIL : (this.emailIsChanged() && this.isEmailInUse() ? ERROR_EMAIL_IN_USE : (!this.isEmailValidFormat() ? ERROR_EMAIL_INVALID_FORMAT : (this.firstName.isEmpty() ? ERROR_NO_FIRST_NAME : (this.lastName.isEmpty() ? ERROR_NO_LAST_NAME : this.strategy.additionalValidations()))));
    }

    private boolean emailIsChanged() {
        return !this.emailAddress.equals(this.userAccount.getEmailAddress());
    }

    private boolean isEmailInUse() {
        return this.userAccountsDao.getUserAccountByEmail(this.emailAddress) != null;
    }

    private boolean isEmailValidFormat() {
        return Authenticator.isValidEmailAddress(this.emailAddress);
    }

    public boolean isValid() {
        return this.errorCode.isEmpty();
    }

    private boolean isExternalAccount() {
        return LoginStatusBean.getBean((HttpServletRequest)this.vreq).hasExternalAuthentication();
    }

    public final ResponseValues showPage() {
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (this.isSubmit()) {
            body.put(PARAMETER_EMAIL_ADDRESS, this.emailAddress);
            body.put(PARAMETER_FIRST_NAME, this.firstName);
            body.put(PARAMETER_LAST_NAME, this.lastName);
            body.put("proxies", this.buildOngoingProxyList());
        } else {
            body.put(PARAMETER_EMAIL_ADDRESS, this.userAccount.getEmailAddress());
            body.put(PARAMETER_FIRST_NAME, this.userAccount.getFirstName());
            body.put(PARAMETER_LAST_NAME, this.userAccount.getLastName());
            body.put("proxies", this.buildOriginalProxyList());
        }
        body.put("formUrls", this.buildUrlsMap());
        body.put("myAccountUri", this.userAccount.getUri());
        body.put("profileTypes", this.buildProfileTypesString());
        body.put("matchingProperty", SelfEditingConfiguration.getBean((ServletRequest)this.vreq).getMatchingPropertyUri());
        if (this.userAccount.isExternalAuthOnly()) {
            body.put("externalAuthOnly", Boolean.TRUE);
        }
        if (!this.errorCode.isEmpty()) {
            body.put(this.errorCode, Boolean.TRUE);
        }
        if (!this.confirmationCode.isEmpty()) {
            body.put(this.confirmationCode, Boolean.TRUE);
        }
        if (this.isProxyPanelAuthorized()) {
            body.put("showProxyPanel", Boolean.TRUE);
        }
        this.strategy.addMoreBodyValues(body);
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }

    private String buildProfileTypesString() {
        return ConfigurationProperties.getBean((ServletRequest)this.vreq).getProperty(PROPERTY_PROFILE_TYPES, "http://www.w3.org/2002/07/owl#Thing");
    }

    public void updateAccount() {
        this.userAccount.setEmailAddress(this.emailAddress);
        this.userAccount.setFirstName(this.firstName);
        this.userAccount.setLastName(this.lastName);
        Individual profilePage = this.getProfilePage(this.userAccount);
        if (profilePage != null) {
            this.userAccountsDao.setProxyAccountsOnProfile(profilePage.getURI(), this.proxyUris);
        }
        this.strategy.setAdditionalProperties(this.userAccount);
        this.userAccountsDao.updateUserAccount(this.userAccount);
        this.strategy.notifyUser();
        this.confirmationCode = this.strategy.getConfirmationCode();
    }

    boolean isProxyPanelAuthorized() {
        return PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, new AuthorizationRequest[]{SimplePermission.MANAGE_OWN_PROXIES.ACTION}) && this.getProfilePage(this.userAccount) != null;
    }

    boolean isExternalAuthOnly() {
        return this.userAccount != null && this.userAccount.isExternalAuthOnly();
    }

    private List<ProxyInfo> buildOngoingProxyList() {
        ArrayList<UserAccount> proxyUsers = new ArrayList<UserAccount>();
        for (String proxyUri : this.proxyUris) {
            UserAccount proxyUser = this.userAccountsDao.getUserAccountByUri(proxyUri);
            if (proxyUser == null) {
                log.warn((Object)("No UserAccount found for proxyUri: " + proxyUri));
                continue;
            }
            proxyUsers.add(proxyUser);
        }
        return this.buildProxyListFromUserAccounts(proxyUsers);
    }

    private List<ProxyInfo> buildOriginalProxyList() {
        Collection<UserAccount> proxyUsers;
        Individual profilePage = this.getProfilePage(this.userAccount);
        if (profilePage == null) {
            log.debug((Object)"no profile page");
            proxyUsers = Collections.emptyList();
        } else {
            String uri = profilePage.getURI();
            log.debug((Object)("profile page at " + uri));
            proxyUsers = this.userAccountsDao.getUserAccountsWhoProxyForPage(uri);
            if (log.isDebugEnabled()) {
                log.debug(this.getUrisFromUserAccounts(proxyUsers));
            }
        }
        return this.buildProxyListFromUserAccounts(proxyUsers);
    }

    private Individual getProfilePage(UserAccount ua) {
        SelfEditingConfiguration sec = SelfEditingConfiguration.getBean((ServletRequest)this.vreq);
        List<Individual> profilePages = sec.getAssociatedIndividuals(this.indDao, ua);
        if (profilePages.isEmpty()) {
            return null;
        }
        return profilePages.get(0);
    }

    private List<ProxyInfo> buildProxyListFromUserAccounts(Collection<UserAccount> proxyUsers) {
        ArrayList<ProxyInfo> proxyInfos = new ArrayList<ProxyInfo>();
        for (UserAccount proxyUser : proxyUsers) {
            proxyInfos.add(this.assembleProxyInfoForUser(proxyUser));
        }
        return proxyInfos;
    }

    private ProxyInfo assembleProxyInfoForUser(UserAccount proxyUser) {
        String userUri = proxyUser.getUri();
        String label = this.assembleUserAccountLabel(proxyUser);
        String classLabel = "";
        String imageUrl = UrlBuilder.getUrl(PlaceholderUtil.getPlaceholderImagePathForType(this.vreq, "http://vitro.mannlib.cornell.edu/ns/vitro/authorization#UserAccount"));
        Individual proxyProfilePage = this.getProfilePage(proxyUser);
        if (proxyProfilePage != null) {
            String thumbUrl = proxyProfilePage.getThumbUrl();
            if (thumbUrl != null && !thumbUrl.isEmpty()) {
                imageUrl = UrlBuilder.getUrl(thumbUrl);
            }
            classLabel = this.getMostSpecificTypeLabel(proxyProfilePage.getURI());
        }
        return new ProxyInfo(userUri, label, classLabel, imageUrl);
    }

    private String assembleUserAccountLabel(UserAccount ua) {
        String last = ua.getLastName();
        String first = ua.getFirstName();
        if (last.isEmpty()) {
            return first;
        }
        if (first.isEmpty()) {
            return last;
        }
        return last + ", " + first;
    }

    private String getMostSpecificTypeLabel(String uri) {
        Map<String, String> types = this.opsDao.getMostSpecificTypesInClassgroupsForIndividual(uri);
        if (types.isEmpty()) {
            return "";
        }
        return types.values().iterator().next();
    }

    private List<String> getUrisFromUserAccounts(Collection<UserAccount> proxyUsers) {
        ArrayList<String> list = new ArrayList<String>();
        for (UserAccount u : proxyUsers) {
            list.add(u.getUri());
        }
        return list;
    }

    public static class ProxyInfo {
        private final String uri;
        private final String label;
        private final String classLabel;
        private final String imageUrl;

        public ProxyInfo(String uri, String label, String classLabel, String imageUrl) {
            this.uri = uri;
            this.label = label;
            this.classLabel = classLabel;
            this.imageUrl = imageUrl;
        }

        public String getUri() {
            return this.uri;
        }

        public String getLabel() {
            return this.label;
        }

        public String getClassLabel() {
            return this.classLabel;
        }

        public String getImageUrl() {
            return this.imageUrl;
        }
    }
}

