/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ajax;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.SelfEditingConfiguration;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.AbstractAjaxResponder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoreProxyInfo
extends AbstractAjaxResponder {
    private static final Log log = LogFactory.getLog(MoreProxyInfo.class);
    private static final String PARAMETER_PROXY_URI = "uri";
    private final ObjectPropertyStatementDao opsDao;
    private final String proxyUri;

    public MoreProxyInfo(HttpServlet servlet, VitroRequest vreq, HttpServletResponse resp) {
        super(servlet, vreq, resp);
        this.opsDao = vreq.getWebappDaoFactory().getObjectPropertyStatementDao();
        this.proxyUri = this.getStringParameter(PARAMETER_PROXY_URI, "");
    }

    @Override
    public String prepareResponse() throws IOException {
        log.debug((Object)("proxy URI is '" + this.proxyUri + "'"));
        if (this.proxyUri.isEmpty()) {
            return "[]";
        }
        UserAccount user = this.uaDao.getUserAccountByUri(this.proxyUri);
        if (user == null) {
            log.debug((Object)"no such user");
            return "[]";
        }
        List<Individual> inds = SelfEditingConfiguration.getBean((ServletRequest)this.vreq).getAssociatedIndividuals(this.indDao, user);
        if (inds.isEmpty()) {
            log.debug((Object)"no profile");
            return "[]";
        }
        Individual profileInd = inds.get(0);
        HashMap<String, String> map = new HashMap<String, String>();
        String imagePath = profileInd.getThumbUrl();
        if (imagePath != null && !imagePath.isEmpty()) {
            map.put("imageUrl", UrlBuilder.getUrl(imagePath));
        }
        map.put("classLabel", this.getMostSpecificTypeLabel(profileInd.getURI()));
        ArrayNode jsonArray = JsonNodeFactory.instance.arrayNode();
        ObjectNode jsonObj = JsonNodeFactory.instance.objectNode();
        for (Map.Entry entry : map.entrySet()) {
            jsonObj.put((String)entry.getKey(), (String)entry.getValue());
        }
        jsonArray.add((JsonNode)jsonObj);
        String response = jsonArray.toString();
        log.debug((Object)("response is '" + response + "'"));
        return response;
    }

    private String getMostSpecificTypeLabel(String uri) {
        Map<String, String> types = this.opsDao.getMostSpecificTypesInClassgroupsForIndividual(uri);
        if (types.isEmpty()) {
            return "";
        }
        return types.values().iterator().next();
    }
}

