/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.manageproxies.ajax;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.AbstractAjaxResponder;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.AutoCompleteWords;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.FieldMap;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.SearchQueryUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicProfilesGetter
extends AbstractAjaxResponder {
    private static final Log log = LogFactory.getLog(BasicProfilesGetter.class);
    private static final String WORD_DELIMITER = "[, ]+";
    private static final FieldMap RESPONSE_FIELDS = SearchQueryUtils.fieldMap().put("URI", "uri").put("nameRaw", "label").put("bogus", "classLabel").put("bogus", "imageUrl");
    private static final String PROPERTY_PROFILE_TYPES = "proxy.eligibleTypeList";
    private static final String PARAMETER_SEARCH_TERM = "term";
    private static final String DEFAULT_PROFILE_TYPES = "http://www.w3.org/2002/07/owl#Thing";
    private final String term = this.getStringParameter("term", "");
    private final AutoCompleteWords searchWords = SearchQueryUtils.parseForAutoComplete(this.term, "[, ]+");
    private final List<String> profileTypes = this.figureProfileTypes();

    public BasicProfilesGetter(HttpServlet servlet, VitroRequest vreq, HttpServletResponse resp) {
        super(servlet, vreq, resp);
        log.debug((Object)this);
    }

    private List<String> figureProfileTypes() {
        String typesString = ConfigurationProperties.getBean((ServletRequest)this.vreq).getProperty(PROPERTY_PROFILE_TYPES, DEFAULT_PROFILE_TYPES);
        List<String> list = SearchQueryUtils.parseWords(typesString, WORD_DELIMITER);
        if (list.isEmpty()) {
            log.error((Object)"No types configured for profile pages in proxy.eligibleTypeList");
        }
        return list;
    }

    @Override
    public String prepareResponse() throws IOException {
        log.debug((Object)("search term is '" + this.term + "'"));
        if (this.term.isEmpty() || this.profileTypes.isEmpty()) {
            return "[]";
        }
        try {
            SearchEngine search = ApplicationUtils.instance().getSearchEngine();
            SearchQuery query = this.buildSearchQuery();
            SearchResponse queryResponse = search.query(query);
            List<Map<String, String>> parsed = SearchQueryUtils.parseResponse(queryResponse, RESPONSE_FIELDS);
            String response = this.assembleJsonResponse(parsed);
            log.debug((Object)response);
            return response;
        }
        catch (SearchEngineException e) {
            log.error((Object)"Failed to get basic profile info", (Throwable)e);
            return "[]";
        }
    }

    private SearchQuery buildSearchQuery() {
        SearchQuery q = ApplicationUtils.instance().getSearchEngine().createQuery();
        q.addFields("nameRaw", "URI");
        q.addSortField("nameLowercaseSingleValued", SearchQuery.Order.ASC);
        q.addFilterQuery(SearchQueryUtils.assembleConjunctiveQuery("type", this.profileTypes, SearchQueryUtils.Conjunction.OR));
        q.setStart(0);
        q.setRows(30);
        q.setQuery(this.searchWords.assembleQuery("nameUnstemmed", "acNameStemmed"));
        return q;
    }

    public String toString() {
        return "BasicProfilesGetter[term=" + this.term + ", searchWords=" + this.searchWords + ", profileTypes=" + this.profileTypes + "]";
    }
}

