/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts;

import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.PermissionSet;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.AbstractPageHandler;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.email.FreemarkerEmailFactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UserAccountsPage
extends AbstractPageHandler {
    private static final Log log = LogFactory.getLog(UserAccountsPage.class);
    private static final String PERSON_CLASS_URI = "http://xmlns.com/foaf/0.1/Person";
    protected static final int DAYS_TO_USE_PASSWORD_LINK = 90;

    protected UserAccountsPage(VitroRequest vreq) {
        super(vreq);
    }

    protected boolean isEmailEnabled() {
        return FreemarkerEmailFactory.isConfigured((HttpServletRequest)this.vreq);
    }

    protected List<PermissionSet> buildListOfSelectableRoles() {
        ArrayList<PermissionSet> list = new ArrayList<PermissionSet>();
        for (PermissionSet ps : this.userAccountsDao.getAllPermissionSets()) {
            if (ps.isForPublic()) continue;
            list.add(ps);
        }
        list.sort(new Comparator<PermissionSet>(){

            @Override
            public int compare(PermissionSet ps1, PermissionSet ps2) {
                return ps1.getUri().compareTo(ps2.getUri());
            }
        });
        return list;
    }

    protected SortedMap<String, String> buildProfileTypesList() {
        String seedClassUri = PERSON_CLASS_URI;
        List<String> classUris = this.vclassDao.getAllSubClassURIs(seedClassUri);
        classUris.add(seedClassUri);
        TreeMap<String, String> types = new TreeMap<String, String>();
        for (String classUri : classUris) {
            VClass vclass = this.vclassDao.getVClassByURI(classUri);
            if (vclass == null) continue;
            types.put(classUri, vclass.getName());
        }
        return types;
    }

    protected Map<String, String> buildUrlsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("list", UrlBuilder.getUrl("/accountsAdmin/list"));
        map.put("add", UrlBuilder.getUrl("/accountsAdmin/add"));
        map.put("delete", UrlBuilder.getUrl("/accountsAdmin/delete"));
        map.put("myAccount", UrlBuilder.getUrl("/accounts/myAccount"));
        map.put("createPassword", UrlBuilder.getUrl("/accounts/createPassword"));
        map.put("resetPassword", UrlBuilder.getUrl("/accounts/resetPassword"));
        map.put("firstTimeExternal", UrlBuilder.getUrl("/accounts/firstTimeExternal"));
        map.put("accountsAjax", UrlBuilder.getUrl("/accountsAjax"));
        map.put("proxyAjax", UrlBuilder.getUrl("/proxiesAjax"));
        return map;
    }

    protected static String editAccountUrl(String uri) {
        return UrlBuilder.getUrl("/accountsAdmin/edit", new UrlBuilder.ParamMap("editAccount", uri));
    }

    protected Date figureExpirationDate() {
        Calendar c = Calendar.getInstance();
        c.add(5, 90);
        return c.getTime();
    }

    protected boolean checkPasswordLength(String pw) {
        return pw.length() >= 6 && pw.length() <= 64;
    }

    protected String getSiteName() {
        ApplicationBean appBean = this.vreq.getAppBean();
        return appBean.getApplicationName();
    }

    protected ProfileInfo buildProfileInfo(String uri) {
        Individual ind = this.indDao.getIndividualByURI(uri);
        if (ind == null) {
            return null;
        }
        return new ProfileInfo(ind.getRdfsLabel(), uri, UrlBuilder.getIndividualProfileUrl(uri, this.vreq));
    }

    public static class ProfileInfo {
        private final String label;
        private final String uri;
        private final String url;

        public ProfileInfo(String label, String uri, String url) {
            this.label = label;
            this.uri = uri;
            this.url = url;
        }

        public String getLabel() {
            return this.label;
        }

        public String getUri() {
            return this.uri;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

