/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyList;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import java.util.ListIterator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletPolicyList {
    private static final String ATTRIBUTE_POLICY_LIST = ServletPolicyList.class.getName();
    private static final Log log = LogFactory.getLog(ServletPolicyList.class);

    public static PolicyIface getPolicies(HttpServletRequest hreq) {
        return ServletPolicyList.getPolicies(hreq.getSession().getServletContext());
    }

    public static PolicyList getPolicies(ServletContext sc) {
        return new PolicyList(ServletPolicyList.getPolicyList(sc));
    }

    public static void addPolicy(ServletContext sc, PolicyIface policy) {
        if (policy == null) {
            return;
        }
        PolicyList policies = ServletPolicyList.getPolicyList(sc);
        if (!policies.contains(policy)) {
            policies.add(policy);
            log.debug((Object)("Added policy: " + policy.toString()));
        } else {
            log.warn((Object)"Ignored attempt to add redundant policy.");
        }
    }

    public static void addPolicyAtFront(ServletContext sc, PolicyIface policy) {
        if (policy == null) {
            return;
        }
        PolicyList policies = ServletPolicyList.getPolicyList(sc);
        if (!policies.contains(policy)) {
            policies.add(0, policy);
            log.debug((Object)("Added policy at front: " + policy.toString()));
        } else {
            log.warn((Object)"Ignored attempt to add redundant policy.");
        }
    }

    public static void replacePolicy(ServletContext sc, PolicyIface policy) {
        if (policy == null) {
            return;
        }
        Class<?> clzz = policy.getClass();
        PolicyList policies = ServletPolicyList.getPolicyList(sc);
        ListIterator<PolicyIface> it = policies.listIterator();
        while (it.hasNext()) {
            if (!clzz.isAssignableFrom(((PolicyIface)it.next()).getClass())) continue;
            it.set(policy);
            return;
        }
        ServletPolicyList.addPolicy(sc, policy);
    }

    private static PolicyList getPolicyList(ServletContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx may not be null.");
        }
        Object obj = ctx.getAttribute(ATTRIBUTE_POLICY_LIST);
        if (obj == null) {
            obj = new PolicyList();
            ctx.setAttribute(ATTRIBUTE_POLICY_LIST, obj);
        }
        if (!(obj instanceof PolicyList)) {
            throw new IllegalStateException("Expected to find an instance of " + PolicyList.class.getName() + " in the context, but found an instance of " + obj.getClass().getName() + " instead.");
        }
        return (PolicyList)obj;
    }
}

