/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasPermission;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.Permission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.BasicPolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Authorization;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PermissionsPolicy
implements PolicyIface {
    private static final Log log = LogFactory.getLog(PermissionsPolicy.class);

    @Override
    public PolicyDecision isAuthorized(IdentifierBundle whoToAuth, RequestedAction whatToAuth) {
        if (whoToAuth == null) {
            return this.defaultDecision("whomToAuth was null");
        }
        if (whatToAuth == null) {
            return this.defaultDecision("whatToAuth was null");
        }
        for (Permission p : HasPermission.getPermissions(whoToAuth)) {
            if (p.isAuthorized(whatToAuth)) {
                log.debug((Object)("Permission " + p + " approves request " + whatToAuth));
                return new BasicPolicyDecision(Authorization.AUTHORIZED, "PermissionsPolicy: approved by " + p);
            }
            log.trace((Object)("Permission " + p + " denies request " + whatToAuth));
        }
        log.debug((Object)("No permission will approve " + whatToAuth));
        return this.defaultDecision("no permission will approve " + whatToAuth);
    }

    private PolicyDecision defaultDecision(String message) {
        return new BasicPolicyDecision(Authorization.INCONCLUSIVE, message);
    }

    public String toString() {
        return "PermissionsPolicy - " + this.hashCode();
    }
}

