/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.identifier.common;

import edu.cornell.mannlib.vitro.webapp.auth.identifier.Identifier;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.AbstractCommonIdentifier;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.Permission;
import java.util.Collection;
import java.util.HashSet;

public class HasPermission
extends AbstractCommonIdentifier
implements Identifier,
Comparable<HasPermission> {
    private final Permission permission;

    public static Collection<HasPermission> getIdentifiers(IdentifierBundle ids) {
        return HasPermission.getIdentifiersForClass(ids, HasPermission.class);
    }

    public static Collection<Permission> getPermissions(IdentifierBundle ids) {
        HashSet<Permission> set = new HashSet<Permission>();
        for (HasPermission id : HasPermission.getIdentifiers(ids)) {
            set.add(id.getPermission());
        }
        return set;
    }

    public HasPermission(Permission permission) {
        if (permission == null) {
            throw new NullPointerException("permission may not be null.");
        }
        this.permission = permission;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public String toString() {
        return "HasPermission[" + this.permission + "]";
    }

    public int hashCode() {
        return this.permission.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HasPermission)) {
            return false;
        }
        HasPermission that = (HasPermission)obj;
        return this.permission.equals(that.permission);
    }

    @Override
    public int compareTo(HasPermission that) {
        return this.permission.compareTo(that.permission);
    }
}

