/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vedit.validator.impl;

import edu.cornell.mannlib.vedit.validator.ValidationObject;
import edu.cornell.mannlib.vedit.validator.Validator;

public class IntValidator
implements Validator {
    protected int minVal = 0;
    protected int maxVal = Integer.MAX_VALUE;

    @Override
    public ValidationObject validate(Object obj) throws IllegalArgumentException {
        ValidationObject vo = new ValidationObject();
        int theInt = -1;
        if (obj instanceof String) {
            try {
                theInt = Integer.parseInt((String)obj);
            }
            catch (NumberFormatException e) {
                vo.setValid(false);
                vo.setMessage("Please enter an integer");
                vo.setValidatedObject(obj);
                return vo;
            }
        }
        try {
            theInt = (Integer)obj;
        }
        catch (Exception e) {
            vo.setValid(false);
            vo.setMessage("Please enter an integer");
            vo.setValidatedObject(obj);
            return vo;
        }
        if (theInt < this.minVal || theInt > this.maxVal) {
            vo.setValid(false);
            vo.setMessage("Enter a number between " + this.minVal + " and " + this.maxVal);
        } else {
            vo.setValid(true);
        }
        vo.setValidatedObject(obj);
        return vo;
    }

    public IntValidator() {
    }

    public IntValidator(int minVal, int maxVal) {
        this.minVal = minVal;
        this.maxVal = maxVal;
    }
}

