/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc.interfaces;

import android.net.Uri;
import org.videolan.libvlc.interfaces.AbstractVLCEvent;
import org.videolan.libvlc.interfaces.IMediaList;
import org.videolan.libvlc.interfaces.IVLCObject;

public interface IMedia
extends IVLCObject<Event> {
    public long getDuration();

    public IMediaList subItems();

    public boolean parse(int var1);

    public boolean parse();

    public boolean parseAsync(int var1, int var2);

    public boolean parseAsync(int var1);

    public boolean parseAsync();

    public int getType();

    public Track[] getTracks(int var1);

    public Track[] getTracks();

    public String getMeta(int var1);

    public String getMeta(int var1, boolean var2);

    public void setHWDecoderEnabled(boolean var1, boolean var2);

    public void setEventListener(EventListener var1);

    public void addOption(String var1);

    public void addSlave(Slave var1);

    public void clearSlaves();

    public Slave[] getSlaves();

    public Uri getUri();

    public boolean isParsed();

    public Stats getStats();

    public void setDefaultMediaPlayerOptions();

    public static class Stats {
        public final long readBytes;
        public final float inputBitrate;
        public final long demuxReadBytes;
        public final float demuxBitrate;
        public final long demuxCorrupted;
        public final long demuxDiscontinuity;
        public final long decodedVideo;
        public final long decodedAudio;
        public final long displayedPictures;
        public final long lostPictures;
        public final long playedAbuffers;
        public final long lostAbuffers;
        public final long sentPackets;
        public final long sentBytes;
        public final float sendBitrate;

        public Stats(long readBytes, float inputBitrate, long demuxReadBytes, float demuxBitrate, long demuxCorrupted, long demuxDiscontinuity, long decodedVideo, long decodedAudio, long displayedPictures, long lostPictures, long playedAbuffers, long lostAbuffers, long sentPackets, long sentBytes, float sendBitrate) {
            this.readBytes = readBytes;
            this.inputBitrate = inputBitrate;
            this.demuxReadBytes = demuxReadBytes;
            this.demuxBitrate = demuxBitrate;
            this.demuxCorrupted = demuxCorrupted;
            this.demuxDiscontinuity = demuxDiscontinuity;
            this.decodedVideo = decodedVideo;
            this.decodedAudio = decodedAudio;
            this.displayedPictures = displayedPictures;
            this.lostPictures = lostPictures;
            this.playedAbuffers = playedAbuffers;
            this.lostAbuffers = lostAbuffers;
            this.sentPackets = sentPackets;
            this.sentBytes = sentBytes;
            this.sendBitrate = sendBitrate;
        }
    }

    public static class Slave {
        public final int type;
        public final int priority;
        public final String uri;

        public Slave(int type, int priority, String uri) {
            this.type = type;
            this.priority = priority;
            this.uri = uri;
        }

        public static class Type {
            public static final int Subtitle = 0;
            public static final int Audio = 1;
        }
    }

    public static class UnknownTrack
    extends Track {
        public UnknownTrack(String id2, String name, boolean selected, String codec, String originalCodec, int fourcc, int profile, int level, int bitrate, String language, String description) {
            super(-1, id2, name, selected, codec, originalCodec, fourcc, profile, level, bitrate, language, description);
        }
    }

    public static class SubtitleTrack
    extends Track {
        public final String encoding;

        public SubtitleTrack(String id2, String name, boolean selected, String codec, String originalCodec, int fourcc, int profile, int level, int bitrate, String language, String description, String encoding) {
            super(2, id2, name, selected, codec, originalCodec, fourcc, profile, level, bitrate, language, description);
            this.encoding = encoding;
        }
    }

    public static class VideoTrack
    extends Track {
        public final int height;
        public final int width;
        public final int sarNum;
        public final int sarDen;
        public final int frameRateNum;
        public final int frameRateDen;
        public final int orientation;
        public final int projection;

        public VideoTrack(String id2, String name, boolean selected, String codec, String originalCodec, int fourcc, int profile, int level, int bitrate, String language, String description, int height, int width, int sarNum, int sarDen, int frameRateNum, int frameRateDen, int orientation, int projection) {
            super(1, id2, name, selected, codec, originalCodec, fourcc, profile, level, bitrate, language, description);
            this.height = height;
            this.width = width;
            this.sarNum = sarNum;
            this.sarDen = sarDen;
            this.frameRateNum = frameRateNum;
            this.frameRateDen = frameRateDen;
            this.orientation = orientation;
            this.projection = projection;
        }

        public static final class Projection {
            public static final int Rectangular = 0;
            public static final int EquiRectangular = 1;
            public static final int CubemapLayoutStandard = 256;
        }

        public static final class Orientation {
            public static final int TopLeft = 0;
            public static final int TopRight = 1;
            public static final int BottomLeft = 2;
            public static final int BottomRight = 3;
            public static final int LeftTop = 4;
            public static final int LeftBottom = 5;
            public static final int RightTop = 6;
            public static final int RightBottom = 7;
        }
    }

    public static class AudioTrack
    extends Track {
        public final int channels;
        public final int rate;

        public AudioTrack(String id2, String name, boolean selected, String codec, String originalCodec, int fourcc, int profile, int level, int bitrate, String language, String description, int channels, int rate) {
            super(0, id2, name, selected, codec, originalCodec, fourcc, profile, level, bitrate, language, description);
            this.channels = channels;
            this.rate = rate;
        }
    }

    public static abstract class Track {
        public final int type;
        public final String id;
        public final String name;
        public final boolean selected;
        public final String codec;
        public final String originalCodec;
        public final int fourcc;
        public final int profile;
        public final int level;
        public final int bitrate;
        public final String language;
        public final String description;

        protected Track(int type, String id2, String name, boolean selected, String codec, String originalCodec, int fourcc, int profile, int level, int bitrate, String language, String description) {
            this.type = type;
            this.id = id2;
            this.name = name;
            this.selected = selected;
            this.codec = codec;
            this.originalCodec = originalCodec;
            this.fourcc = fourcc;
            this.profile = profile;
            this.level = level;
            this.bitrate = bitrate;
            this.language = language;
            this.description = description;
        }

        public static class Type {
            public static final int Unknown = -1;
            public static final int Audio = 0;
            public static final int Video = 1;
            public static final int Text = 2;
        }
    }

    public static class ParsedStatus {
        public static final int Skipped = 1;
        public static final int Failed = 2;
        public static final int Timeout = 3;
        public static final int Done = 4;
    }

    public static class Parse {
        public static final int ParseLocal = 1;
        public static final int ParseNetwork = 2;
        public static final int ParseForced = 4;
        public static final int FetchLocal = 8;
        public static final int FetchNetwork = 16;
        public static final int DoInteract = 32;
    }

    public static class State {
        public static final int NothingSpecial = 0;
        public static final int Opening = 1;
        public static final int Playing = 3;
        public static final int Paused = 4;
        public static final int Stopped = 5;
        public static final int Ended = 6;
        public static final int Error = 7;
        public static final int MAX = 8;
    }

    public static class Meta {
        public static final int Title = 0;
        public static final int Artist = 1;
        public static final int Genre = 2;
        public static final int Copyright = 3;
        public static final int Album = 4;
        public static final int TrackNumber = 5;
        public static final int Description = 6;
        public static final int Rating = 7;
        public static final int Date = 8;
        public static final int Setting = 9;
        public static final int URL = 10;
        public static final int Language = 11;
        public static final int NowPlaying = 12;
        public static final int Publisher = 13;
        public static final int EncodedBy = 14;
        public static final int ArtworkURL = 15;
        public static final int TrackID = 16;
        public static final int TrackTotal = 17;
        public static final int Director = 18;
        public static final int Season = 19;
        public static final int Episode = 20;
        public static final int ShowName = 21;
        public static final int Actors = 22;
        public static final int AlbumArtist = 23;
        public static final int DiscNumber = 24;
        public static final int MAX = 25;
    }

    public static class Type {
        public static final int Unknown = 0;
        public static final int File = 1;
        public static final int Directory = 2;
        public static final int Disc = 3;
        public static final int Stream = 4;
        public static final int Playlist = 5;
    }

    public static interface EventListener
    extends AbstractVLCEvent.Listener<Event> {
    }

    public static class Event
    extends AbstractVLCEvent {
        public static final int MetaChanged = 0;
        public static final int SubItemAdded = 1;
        public static final int DurationChanged = 2;
        public static final int ParsedChanged = 3;
        public static final int SubItemTreeAdded = 6;

        public Event(int type) {
            super(type);
        }

        public Event(int type, long arg1) {
            super(type, arg1);
        }

        public int getMetaId() {
            return (int)this.arg1;
        }

        public int getParsedStatus() {
            return (int)this.arg1;
        }
    }
}

