/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.libvlc;

import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Handler;
import android.util.Log;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.FrameLayout;
import org.videolan.R;
import org.videolan.libvlc.IVLCVout;
import org.videolan.libvlc.Media;
import org.videolan.libvlc.MediaPlayer;
import org.videolan.libvlc.util.AndroidUtil;
import org.videolan.libvlc.util.DisplayManager;
import org.videolan.libvlc.util.VLCVideoLayout;

class VideoHelper
implements IVLCVout.OnNewVideoLayoutListener {
    private static final String TAG = "LibVLC/VideoHelper";
    private MediaPlayer.ScaleType mCurrentScaleType = MediaPlayer.ScaleType.SURFACE_BEST_FIT;
    private int mVideoHeight = 0;
    private int mVideoWidth = 0;
    private int mVideoVisibleHeight = 0;
    private int mVideoVisibleWidth = 0;
    private int mVideoSarNum = 0;
    private int mVideoSarDen = 0;
    private FrameLayout mVideoSurfaceFrame;
    private SurfaceView mVideoSurface = null;
    private SurfaceView mSubtitlesSurface = null;
    private TextureView mVideoTexture = null;
    private final Handler mHandler = new Handler();
    private View.OnLayoutChangeListener mOnLayoutChangeListener = null;
    private DisplayManager mDisplayManager;
    private MediaPlayer mMediaPlayer;

    VideoHelper(MediaPlayer player, VLCVideoLayout surfaceFrame, DisplayManager dm, boolean subtitles, boolean textureView) {
        this.init(player, surfaceFrame, dm, subtitles, !textureView);
    }

    private void init(MediaPlayer player, VLCVideoLayout surfaceFrame, DisplayManager dm, boolean subtitles, boolean useSurfaceView) {
        boolean isPrimary;
        this.mMediaPlayer = player;
        this.mDisplayManager = dm;
        boolean bl = isPrimary = this.mDisplayManager == null || this.mDisplayManager.isPrimary();
        if (isPrimary) {
            this.mVideoSurfaceFrame = (FrameLayout)surfaceFrame.findViewById(R.id.player_surface_frame);
            if (useSurfaceView) {
                ViewStub stub = (ViewStub)this.mVideoSurfaceFrame.findViewById(R.id.surface_stub);
                SurfaceView surfaceView = this.mVideoSurface = stub != null ? (SurfaceView)stub.inflate() : (SurfaceView)this.mVideoSurfaceFrame.findViewById(R.id.surface_video);
                if (subtitles) {
                    stub = (ViewStub)this.mVideoSurfaceFrame.findViewById(R.id.subtitles_surface_stub);
                    this.mSubtitlesSurface = stub != null ? (SurfaceView)stub.inflate() : (SurfaceView)this.mVideoSurfaceFrame.findViewById(R.id.surface_subtitles);
                    this.mSubtitlesSurface.setZOrderMediaOverlay(true);
                    this.mSubtitlesSurface.getHolder().setFormat(-3);
                }
            } else {
                ViewStub stub = (ViewStub)this.mVideoSurfaceFrame.findViewById(R.id.texture_stub);
                this.mVideoTexture = stub != null ? (TextureView)stub.inflate() : (TextureView)this.mVideoSurfaceFrame.findViewById(R.id.texture_video);
            }
        } else if (this.mDisplayManager.getPresentation() != null) {
            this.mVideoSurfaceFrame = this.mDisplayManager.getPresentation().getSurfaceFrame();
            this.mVideoSurface = this.mDisplayManager.getPresentation().getSurfaceView();
            this.mSubtitlesSurface = this.mDisplayManager.getPresentation().getSubtitlesSurfaceView();
        }
    }

    void release() {
        if (this.mMediaPlayer.getVLCVout().areViewsAttached()) {
            this.detachViews();
        }
        this.mMediaPlayer = null;
        this.mVideoSurfaceFrame = null;
        this.mHandler.removeCallbacks(null);
        this.mVideoSurface = null;
        this.mSubtitlesSurface = null;
        this.mVideoTexture = null;
    }

    void attachViews() {
        if (this.mVideoSurface == null && this.mVideoTexture == null) {
            return;
        }
        IVLCVout vlcVout = this.mMediaPlayer.getVLCVout();
        if (this.mVideoSurface != null) {
            vlcVout.setVideoView(this.mVideoSurface);
            if (this.mSubtitlesSurface != null) {
                vlcVout.setSubtitlesView(this.mSubtitlesSurface);
            }
        } else if (this.mVideoTexture != null) {
            vlcVout.setVideoView(this.mVideoTexture);
        } else {
            return;
        }
        vlcVout.attachViews(this);
        if (this.mOnLayoutChangeListener == null) {
            this.mOnLayoutChangeListener = new View.OnLayoutChangeListener(){
                private final Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (VideoHelper.this.mVideoSurfaceFrame != null && VideoHelper.this.mOnLayoutChangeListener != null) {
                            VideoHelper.this.updateVideoSurfaces();
                        }
                    }
                };

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    if (left != oldLeft || top != oldTop || right != oldRight || bottom != oldBottom) {
                        VideoHelper.this.mHandler.removeCallbacks(this.runnable);
                        VideoHelper.this.mHandler.post(this.runnable);
                    }
                }
            };
        }
        this.mVideoSurfaceFrame.addOnLayoutChangeListener(this.mOnLayoutChangeListener);
        this.mMediaPlayer.setVideoTrackEnabled(true);
    }

    void detachViews() {
        if (this.mOnLayoutChangeListener != null && this.mVideoSurfaceFrame != null) {
            this.mVideoSurfaceFrame.removeOnLayoutChangeListener(this.mOnLayoutChangeListener);
            this.mOnLayoutChangeListener = null;
        }
        this.mMediaPlayer.setVideoTrackEnabled(false);
        this.mMediaPlayer.getVLCVout().detachViews();
    }

    private void changeMediaPlayerLayout(int displayW, int displayH) {
        if (this.mMediaPlayer.isReleased()) {
            return;
        }
        switch (this.mCurrentScaleType) {
            case SURFACE_BEST_FIT: {
                this.mMediaPlayer.setAspectRatio(null);
                this.mMediaPlayer.setScale(0.0f);
                break;
            }
            case SURFACE_FIT_SCREEN: 
            case SURFACE_FILL: {
                boolean videoSwapped;
                Media.VideoTrack vtrack = this.mMediaPlayer.getCurrentVideoTrack();
                if (vtrack == null) {
                    return;
                }
                boolean bl = videoSwapped = vtrack.orientation == 5 || vtrack.orientation == 6;
                if (this.mCurrentScaleType == MediaPlayer.ScaleType.SURFACE_FIT_SCREEN) {
                    float ar;
                    float dar;
                    int videoW = vtrack.width;
                    int videoH = vtrack.height;
                    if (videoSwapped) {
                        int swap = videoW;
                        videoW = videoH;
                        videoH = swap;
                    }
                    if (vtrack.sarNum != vtrack.sarDen) {
                        videoW = videoW * vtrack.sarNum / vtrack.sarDen;
                    }
                    float scale = (dar = (float)displayW / (float)displayH) >= (ar = (float)videoW / (float)videoH) ? (float)displayW / (float)videoW : (float)displayH / (float)videoH;
                    this.mMediaPlayer.setScale(scale);
                    this.mMediaPlayer.setAspectRatio(null);
                    break;
                }
                this.mMediaPlayer.setScale(0.0f);
                this.mMediaPlayer.setAspectRatio(!videoSwapped ? "" + displayW + ":" + displayH : "" + displayH + ":" + displayW);
                break;
            }
            case SURFACE_16_9: {
                this.mMediaPlayer.setAspectRatio("16:9");
                this.mMediaPlayer.setScale(0.0f);
                break;
            }
            case SURFACE_4_3: {
                this.mMediaPlayer.setAspectRatio("4:3");
                this.mMediaPlayer.setScale(0.0f);
                break;
            }
            case SURFACE_ORIGINAL: {
                this.mMediaPlayer.setAspectRatio(null);
                this.mMediaPlayer.setScale(1.0f);
            }
        }
    }

    @TargetApi(value=24)
    void updateVideoSurfaces() {
        double ar;
        double vw;
        boolean isPortrait;
        int sh;
        int sw;
        Activity activity;
        if (this.mMediaPlayer == null || this.mMediaPlayer.isReleased()) {
            return;
        }
        boolean isPrimary = this.mDisplayManager == null || this.mDisplayManager.isPrimary();
        Activity activity2 = activity = isPrimary && this.mVideoSurfaceFrame.getContext() instanceof Activity ? (Activity)this.mVideoSurfaceFrame.getContext() : null;
        if (activity != null) {
            sw = activity.getWindow().getDecorView().getWidth();
            sh = activity.getWindow().getDecorView().getHeight();
        } else if (this.mDisplayManager != null && this.mDisplayManager.getPresentation() != null && this.mDisplayManager.getPresentation().getWindow() != null) {
            sw = this.mDisplayManager.getPresentation().getWindow().getDecorView().getWidth();
            sh = this.mDisplayManager.getPresentation().getWindow().getDecorView().getHeight();
        } else {
            return;
        }
        if (sw * sh == 0) {
            Log.e((String)TAG, (String)"Invalid surface size");
            return;
        }
        this.mMediaPlayer.getVLCVout().setWindowSize(sw, sh);
        ViewGroup.LayoutParams lp = this.mVideoSurface.getLayoutParams();
        if (this.mVideoWidth * this.mVideoHeight == 0 || AndroidUtil.isNougatOrLater && activity != null && activity.isInPictureInPictureMode()) {
            lp.width = -1;
            lp.height = -1;
            this.mVideoSurface.setLayoutParams(lp);
            if (this.mSubtitlesSurface != null) {
                this.mSubtitlesSurface.setLayoutParams(lp);
            }
            lp = this.mVideoSurfaceFrame.getLayoutParams();
            lp.width = -1;
            lp.height = -1;
            this.mVideoSurfaceFrame.setLayoutParams(lp);
            if (this.mVideoWidth * this.mVideoHeight == 0) {
                this.changeMediaPlayerLayout(sw, sh);
            }
            return;
        }
        if (lp.width == lp.height && lp.width == -1) {
            this.mMediaPlayer.setAspectRatio(null);
            this.mMediaPlayer.setScale(0.0f);
        }
        double dw = sw;
        double dh = sh;
        boolean bl = isPortrait = isPrimary && this.mVideoSurfaceFrame.getResources().getConfiguration().orientation == 1;
        if (sw > sh && isPortrait || sw < sh && !isPortrait) {
            dw = sh;
            dh = sw;
        }
        if (this.mVideoSarDen == this.mVideoSarNum) {
            vw = this.mVideoVisibleWidth;
            ar = (double)this.mVideoVisibleWidth / (double)this.mVideoVisibleHeight;
        } else {
            vw = (double)this.mVideoVisibleWidth * (double)this.mVideoSarNum / (double)this.mVideoSarDen;
            ar = vw / (double)this.mVideoVisibleHeight;
        }
        double dar = dw / dh;
        switch (this.mCurrentScaleType) {
            case SURFACE_BEST_FIT: {
                if (dar < ar) {
                    dh = dw / ar;
                    break;
                }
                dw = dh * ar;
                break;
            }
            case SURFACE_FIT_SCREEN: {
                if (dar >= ar) {
                    dh = dw / ar;
                    break;
                }
                dw = dh * ar;
                break;
            }
            case SURFACE_FILL: {
                break;
            }
            case SURFACE_16_9: {
                ar = 1.7777777777777777;
                if (dar < ar) {
                    dh = dw / ar;
                    break;
                }
                dw = dh * ar;
                break;
            }
            case SURFACE_4_3: {
                ar = 1.3333333333333333;
                if (dar < ar) {
                    dh = dw / ar;
                    break;
                }
                dw = dh * ar;
                break;
            }
            case SURFACE_ORIGINAL: {
                dh = this.mVideoVisibleHeight;
                dw = vw;
            }
        }
        lp.width = (int)Math.ceil(dw * (double)this.mVideoWidth / (double)this.mVideoVisibleWidth);
        lp.height = (int)Math.ceil(dh * (double)this.mVideoHeight / (double)this.mVideoVisibleHeight);
        this.mVideoSurface.setLayoutParams(lp);
        if (this.mSubtitlesSurface != null) {
            this.mSubtitlesSurface.setLayoutParams(lp);
        }
        lp = this.mVideoSurfaceFrame.getLayoutParams();
        lp.width = (int)Math.floor(dw);
        lp.height = (int)Math.floor(dh);
        this.mVideoSurfaceFrame.setLayoutParams(lp);
        this.mVideoSurface.invalidate();
        if (this.mSubtitlesSurface != null) {
            this.mSubtitlesSurface.invalidate();
        }
    }

    @Override
    @TargetApi(value=17)
    public void onNewVideoLayout(IVLCVout vlcVout, int width, int height, int visibleWidth, int visibleHeight, int sarNum, int sarDen) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        this.mVideoVisibleWidth = visibleWidth;
        this.mVideoVisibleHeight = visibleHeight;
        this.mVideoSarNum = sarNum;
        this.mVideoSarDen = sarDen;
        this.updateVideoSurfaces();
    }

    void setVideoScale(MediaPlayer.ScaleType type) {
        this.mCurrentScaleType = type;
        this.updateVideoSurfaces();
    }

    MediaPlayer.ScaleType getVideoScale() {
        return this.mCurrentScaleType;
    }
}

