/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.util;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSName;
import org.verapdf.factory.colors.ColorSpaceFactory;
import org.verapdf.pd.PDExtGState;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDDeviceCMYK;
import org.verapdf.pd.colors.PDDeviceGray;
import org.verapdf.pd.colors.PDDeviceRGB;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.images.PDXObject;
import org.verapdf.pd.patterns.PDPattern;
import org.verapdf.pd.patterns.PDShading;

public class PDResourcesHandler {
    public static final PDResourcesHandler EMPTY = PDResourcesHandler.getInstance(new PDResources(COSDictionary.construct()), false);
    private final PDResources pageResources;
    private final boolean inheritedResources;
    private final PDResources objectResources;

    private PDResourcesHandler(PDResources pageResources, boolean inheritedResources) {
        this.pageResources = pageResources;
        this.inheritedResources = inheritedResources;
        this.objectResources = null;
    }

    private PDResourcesHandler(PDResources pageResources, PDResources objectResources) {
        this.pageResources = pageResources;
        this.inheritedResources = false;
        this.objectResources = objectResources;
    }

    public static PDResourcesHandler getInstance(PDResources resources, boolean inheritedResources) {
        return new PDResourcesHandler(resources, inheritedResources);
    }

    public static PDResourcesHandler getInstance(PDResources pageResources, PDResources objectResources) {
        return new PDResourcesHandler(pageResources, objectResources);
    }

    public PDResourcesHandler getExtendedResources(PDResources objectResources) {
        return PDResourcesHandler.getInstance(this.pageResources, objectResources);
    }

    public PDFont getFont(COSName name) {
        if (name != null) {
            return this.getFont(name.getName());
        }
        return null;
    }

    public PDFont getFont(ASAtom name) {
        PDFont font;
        if (this.objectResources != null) {
            font = this.objectResources.getFont(name);
            if (font == null) {
                font = this.pageResources.getFont(name);
                this.setInherited((PDResource)font, true);
            }
        } else {
            font = this.pageResources.getFont(name);
            this.setInherited((PDResource)font, this.inheritedResources);
        }
        return font;
    }

    public PDColorSpace getColorSpace(COSName name) {
        if (name != null) {
            return this.getColorSpace(name.getName());
        }
        return null;
    }

    public PDColorSpace getColorSpace(ASAtom name) {
        PDColorSpace colorSpace;
        if (this.objectResources != null) {
            if (this.isDefaultColorSpaceUsed(name)) {
                return this.objectResources.getDefaultColorSpace(name);
            }
            colorSpace = this.objectResources.getColorSpace(name);
            if (colorSpace == null) {
                colorSpace = this.pageResources.getColorSpace(name);
                colorSpace = this.setColorSpaceInherited(colorSpace, true);
            }
        } else {
            if (this.isDefaultColorSpaceUsed(name)) {
                return this.pageResources.getDefaultColorSpace(name);
            }
            colorSpace = this.pageResources.getColorSpace(name);
            colorSpace = this.setColorSpaceInherited(colorSpace, this.inheritedResources);
        }
        return colorSpace;
    }

    public PDPattern getPattern(COSName name) {
        if (name != null) {
            return this.getPattern(name.getName());
        }
        return null;
    }

    public PDPattern getPattern(ASAtom name) {
        PDPattern pattern;
        if (this.objectResources != null) {
            pattern = this.objectResources.getPattern(name);
            if (pattern == null) {
                pattern = this.pageResources.getPattern(name);
                this.setInherited((PDResource)pattern, true);
            }
        } else {
            pattern = this.pageResources.getPattern(name);
            this.setInherited((PDResource)pattern, this.inheritedResources);
        }
        return pattern;
    }

    public PDShading getShading(COSName name) {
        if (name != null) {
            return this.getShading(name.getName());
        }
        return null;
    }

    public PDShading getShading(ASAtom name) {
        PDShading shading;
        if (this.objectResources != null) {
            shading = this.objectResources.getShading(name);
            if (shading == null) {
                shading = this.pageResources.getShading(name);
                this.setInherited((PDResource)shading, true);
            }
        } else {
            shading = this.pageResources.getShading(name);
            this.setInherited((PDResource)shading, this.inheritedResources);
        }
        return shading;
    }

    public PDXObject getXObject(COSName name) {
        if (name != null) {
            return this.getXObject(name.getName());
        }
        return null;
    }

    public PDXObject getXObject(ASAtom name) {
        PDXObject xObject;
        if (this.objectResources != null) {
            xObject = this.objectResources.getXObject(name);
            if (xObject == null) {
                xObject = this.pageResources.getXObject(name);
                this.setInherited((PDResource)xObject, true);
            }
        } else {
            xObject = this.pageResources.getXObject(name);
            this.setInherited((PDResource)xObject, this.inheritedResources);
        }
        return xObject;
    }

    public PDExtGState getExtGState(COSName name) {
        if (name != null) {
            return this.getExtGState(name.getName());
        }
        return null;
    }

    public PDExtGState getExtGState(ASAtom name) {
        PDExtGState state;
        if (this.objectResources != null) {
            state = this.objectResources.getExtGState(name);
            if (state == null) {
                state = this.pageResources.getExtGState(name);
                this.setInherited((PDResource)state, true);
            }
        } else {
            state = this.pageResources.getExtGState(name);
            this.setInherited((PDResource)state, this.inheritedResources);
        }
        return state;
    }

    public PDResource getProperties(COSName name) {
        if (name != null) {
            return this.getProperties(name.getName());
        }
        return null;
    }

    public PDResource getProperties(ASAtom name) {
        PDResource res;
        if (this.objectResources != null) {
            res = this.objectResources.getProperties(name);
            if (res == null) {
                res = this.pageResources.getProperties(name);
                this.setInherited(res, true);
            }
        } else {
            res = this.pageResources.getProperties(name);
            this.setInherited(res, this.inheritedResources);
        }
        return res;
    }

    public PDColorSpace setColorSpaceInherited(PDColorSpace colorSpace, boolean isInherited) {
        if (isInherited) {
            if (colorSpace == PDDeviceCMYK.INSTANCE) {
                return PDDeviceCMYK.INHERITED_INSTANCE;
            }
            if (colorSpace == PDDeviceRGB.INSTANCE) {
                return PDDeviceRGB.INHERITED_INSTANCE;
            }
            if (colorSpace == PDDeviceGray.INSTANCE) {
                return PDDeviceGray.INHERITED_INSTANCE;
            }
        }
        this.setInherited((PDResource)colorSpace, isInherited);
        return colorSpace;
    }

    public void setInherited(PDResource resource, boolean value) {
        if (resource != null) {
            resource.setInherited(value);
        }
    }

    public PDResources getObjectResources() {
        return this.objectResources;
    }

    public PDResources getPageResources() {
        return this.pageResources;
    }

    private boolean isDefaultColorSpaceUsed(ASAtom name) {
        ASAtom value;
        return PDResourcesHandler.isDeviceDependent(name) && (this.objectResources != null ? (value = ColorSpaceFactory.getDefaultValue((PDResources)this.objectResources, (ASAtom)name)) != null : (value = ColorSpaceFactory.getDefaultValue((PDResources)this.pageResources, (ASAtom)name)) != null);
    }

    private static boolean isDeviceDependent(ASAtom name) {
        return ASAtom.DEVICERGB.equals((Object)name) || ASAtom.DEVICEGRAY.equals((Object)name) || ASAtom.DEVICECMYK.equals((Object)name);
    }
}

