/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cmap;

import org.verapdf.pd.font.cmap.CIDMappable;

class CIDInterval
implements CIDMappable {
    private int intervalStart;
    private int intervalEnd;
    protected int startingCID;

    CIDInterval(int intervalStart, int intervalEnd, int startingCID) {
        this.intervalStart = intervalStart;
        this.intervalEnd = intervalEnd;
        this.startingCID = startingCID;
    }

    public boolean contains(int character) {
        return character >= this.intervalStart && character <= this.intervalEnd;
    }

    @Override
    public int getCID(int character) {
        if (!this.contains(character)) {
            return -1;
        }
        return this.startingCID + character - this.intervalStart;
    }

    @Override
    public int getMaxCID() {
        return this.startingCID + this.intervalEnd - this.intervalStart;
    }
}

