/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.as.filters.io;

import java.io.IOException;
import java.util.Arrays;
import org.verapdf.as.filters.ASInFilter;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.parser.NotSeekableBaseParser;

public class ASBufferedInFilter
extends ASInFilter {
    public static final int START_BUFFER_SIZE = 10240;
    public static final int BF_BUFFER_SIZE = 2048;
    private final int HALF;
    private final int BUFFER_FEED_THRESHOLD;
    private int pos = 0;
    private int eod = -1;
    private boolean initialized = false;
    private int readCounter = 0;
    private final int bufferCapacity;
    protected byte[] buffer;
    private int bufferBegin;
    private int bufferEnd;

    public ASBufferedInFilter(ASInputStream stream) throws IOException {
        this(stream, 2048);
    }

    public ASBufferedInFilter(ASInputStream stream, int buffCapacity) {
        super(stream);
        this.bufferCapacity = buffCapacity;
        this.buffer = new byte[buffCapacity];
        this.bufferBegin = 0;
        this.bufferEnd = 0;
        this.HALF = buffCapacity / 2;
        this.BUFFER_FEED_THRESHOLD = 3 * buffCapacity / 4;
    }

    public void initialize() throws IOException {
        this.initialized = true;
        this.readFromStreamToBuffer(this.HALF, this.HALF);
        this.pos = this.HALF;
    }

    @Override
    public int read(byte[] buffer, int size) throws IOException {
        if (this.eod != -1 && this.pos >= this.eod) {
            return -1;
        }
        if (size < this.bufferSize()) {
            int read = this.copyFromBuffer(this.pos, size, buffer);
            this.pos += read;
            if (this.pos > this.BUFFER_FEED_THRESHOLD) {
                this.feedBuffer();
            }
            this.readCounter += read;
            return read;
        }
        int copied = this.copyFromBuffer(this.pos, size, buffer);
        int read = this.getInputStream().read(buffer, copied, size - copied);
        if (read == -1) {
            read = 0;
        }
        this.shiftBuffer(copied + read);
        int sourceBeginOffset = Math.max(0, copied + read - this.buffer.length);
        int destBeginOffset = Math.max(0, this.buffer.length - copied - read);
        int readSize = Math.min(buffer.length, copied + read);
        System.arraycopy(buffer, sourceBeginOffset, this.buffer, destBeginOffset, readSize);
        this.pos = this.buffer.length;
        this.feedBuffer();
        this.readCounter += copied + read;
        return copied + read;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, buffer.length);
    }

    public byte readByte() throws IOException {
        if (this.eod != -1 && this.pos >= this.eod) {
            return -1;
        }
        byte res = this.buffer[this.pos++];
        if (this.pos > this.BUFFER_FEED_THRESHOLD && this.eod == -1) {
            this.feedBuffer();
        }
        ++this.readCounter;
        return res;
    }

    public int processBuffer(int bytesToProcess) {
        int actuallyProcessed = Math.min(bytesToProcess, this.bufferSize());
        this.bufferBegin += bytesToProcess;
        return actuallyProcessed;
    }

    public int feedBuffer(int bytesToRead) throws IOException {
        if (this.getInputStream() == null) {
            return -1;
        }
        bytesToRead = Math.min(bytesToRead, this.bufferCapacity);
        int actuallyRead = this.getInputStream().read(this.buffer, bytesToRead);
        this.bufferBegin = 0;
        this.bufferEnd = actuallyRead;
        return actuallyRead;
    }

    private void feedBuffer() throws IOException {
        if (this.pos > this.HALF) {
            int bytesToFeed = this.pos - this.HALF;
            this.shiftBuffer(bytesToFeed);
            this.readFromStreamToBuffer(this.buffer.length - bytesToFeed, bytesToFeed);
        }
    }

    public int addToBuffer(int bytesToAdd) throws IOException {
        if (this.getInputStream() == null) {
            return -1;
        }
        bytesToAdd = Math.min(bytesToAdd, this.bufferCapacity - this.bufferEnd);
        byte[] toAdd = new byte[bytesToAdd];
        int actuallyRead = this.getInputStream().read(toAdd, bytesToAdd);
        System.arraycopy(toAdd, 0, this.buffer, this.bufferEnd, bytesToAdd);
        this.bufferEnd += bytesToAdd;
        return actuallyRead;
    }

    public int getBufferBegin() {
        return this.bufferBegin;
    }

    public int getBufferEnd() {
        return this.bufferEnd;
    }

    public byte bufferPop() {
        return this.buffer[this.bufferBegin++];
    }

    public int bufferPopArray(byte[] buffer, int read) throws IOException {
        int actualRead = Math.min(read, this.bufferSize());
        if (actualRead == -1) {
            return -1;
        }
        if (buffer.length < actualRead) {
            throw new IOException("Passed buffer is too small");
        }
        System.arraycopy(this.buffer, this.bufferBegin, buffer, 0, actualRead);
        this.bufferBegin += actualRead;
        return actualRead;
    }

    public int bufferSize() {
        return this.bufferEnd - this.bufferBegin;
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    @Override
    public void closeResource() throws IOException {
        super.closeResource();
        this.bufferBegin = 0;
        this.bufferEnd = 0;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.buffer = new byte[this.bufferCapacity];
        this.readCounter = 0;
        this.pos = 0;
        this.bufferBegin = 0;
        this.bufferEnd = 0;
        this.eod = -1;
        if (this.initialized) {
            this.initialize();
        }
    }

    public static byte[] concatenate(byte[] one, int lengthOne, byte[] two, int lengthTwo) {
        if (lengthTwo == -1) {
            lengthTwo = 0;
        }
        if (lengthOne == -1) {
            lengthOne = 0;
        }
        if (lengthOne == 0) {
            return Arrays.copyOfRange(two, 0, lengthTwo);
        }
        if (lengthTwo == 0) {
            return Arrays.copyOfRange(one, 0, lengthOne);
        }
        byte[] res = new byte[lengthOne + lengthTwo];
        System.arraycopy(one, 0, res, 0, lengthOne);
        System.arraycopy(two, 0, res, lengthOne, lengthTwo);
        return res;
    }

    @Override
    public int skip(int size) throws IOException {
        int skipped;
        int read;
        byte[] temp = new byte[Math.min(2048, size)];
        for (skipped = 0; skipped != size; skipped += read) {
            read = this.read(temp, Math.min(size - skipped, 2048));
            if (read != -1) continue;
            return skipped;
        }
        return skipped;
    }

    public byte peek() throws IOException {
        return this.peek(0);
    }

    public byte peek(int i) throws IOException {
        int index = this.pos + i;
        if (index > this.buffer.length || index < 0) {
            throw new IOException("Can't peek at index " + index + " in buffer in ASBufferingInputStream.");
        }
        if (this.eod != -1 && index >= this.eod) {
            return -1;
        }
        return this.buffer[index];
    }

    public void unread() throws IOException {
        this.unread(1);
    }

    public void unread(int i) throws IOException {
        int index = this.pos - i;
        if (index > this.buffer.length || index < 0) {
            throw new IOException("Can't unread for index " + index + " in buffer in ASBufferingInputStream.");
        }
        this.pos = index;
        this.readCounter -= i;
    }

    public boolean isEOF() {
        return this.eod != -1 && this.pos >= this.eod;
    }

    public void resetReadCounter() {
        this.readCounter = 0;
    }

    public int getReadCounter() {
        return this.readCounter;
    }

    private void readFromStreamToBuffer(int offset, int len) throws IOException {
        int read;
        this.bufferEnd = read = this.getInputStream().read(this.buffer, offset, len);
        if (read < len) {
            this.eod = offset + (read == -1 ? 0 : read);
        }
    }

    private int copyFromBuffer(int offset, int size, byte[] res) {
        int endOfData = this.eod != -1 ? Math.min(this.eod, this.buffer.length) : this.buffer.length;
        int actualCopy = Math.min(size, endOfData - offset);
        System.arraycopy(this.buffer, offset, res, 0, actualCopy);
        return actualCopy;
    }

    private void shiftBuffer(int length) {
        if (length > this.buffer.length) {
            length = this.buffer.length;
        }
        for (int i = length; i < this.buffer.length; ++i) {
            this.buffer[i - length] = this.buffer[i];
        }
        this.pos -= length;
        if (this.eod != -1) {
            this.eod -= length;
        }
    }

    public ASInputStream getStream(int length) throws IOException {
        byte[] buf = new byte[10240];
        int pointer = 0;
        byte readByte = this.readByte();
        while (pointer < length && !this.isEOF()) {
            buf[pointer++] = readByte;
            if (pointer == buf.length) {
                buf = NotSeekableBaseParser.extendArray(buf);
            }
            readByte = this.readByte();
        }
        return new ASMemoryInStream(buf, buf.length, false);
    }

    public ASInputStream getStreamUntilToken(byte[] token) throws IOException {
        byte[] buf = new byte[10240];
        int read = this.read(buf, token.length);
        byte readByte = this.readByte();
        int pointer = read;
        if (pointer != token.length) {
            throw new IOException("Stream is shorter than finishing token");
        }
        while (!this.isEOF() && !Arrays.equals(token, Arrays.copyOfRange(buf, pointer - token.length, pointer))) {
            buf[pointer++] = readByte;
            if (pointer == buf.length) {
                buf = NotSeekableBaseParser.extendArray(buf);
            }
            readByte = this.readByte();
        }
        return new ASMemoryInStream(buf, buf.length, false);
    }
}

