/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cff;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.pd.font.CFFNumber;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.cff.CFFCharStringsHandler;
import org.verapdf.pd.font.cff.CFFFontBaseParser;
import org.verapdf.pd.font.cff.CFFFontProgram;
import org.verapdf.pd.font.cff.CFFIndex;
import org.verapdf.pd.font.cff.CFFPredefined;
import org.verapdf.pd.font.cff.CharStringsWidths;
import org.verapdf.pd.font.cmap.CMap;

public class CFFType1FontProgram
extends CFFFontBaseParser
implements FontProgram {
    private static final String NOTDEF_STRING = ".notdef";
    private CMap externalCMap;
    private long encodingOffset = 0L;
    private int[] encoding = new int[256];
    private boolean isStandardEncoding = false;
    private boolean isExpertEncoding = false;
    private Map<String, Integer> charSet;
    private Map<Integer, String> inverseCharSet;
    private String[] encodingStrings;
    private int bias;
    private CFFIndex localSubrIndex;

    CFFType1FontProgram(SeekableInputStream stream, CFFIndex definedNames, CFFIndex globalSubrs, long topDictBeginOffset, long topDictEndOffset, CMap externalCMap, boolean isSubset) {
        super(stream);
        this.definedNames = definedNames;
        this.globalSubrs = globalSubrs;
        this.topDictBeginOffset = topDictBeginOffset;
        this.topDictEndOffset = topDictEndOffset;
        this.externalCMap = externalCMap;
        this.isSubset = isSubset;
    }

    @Override
    public void parseFont() throws IOException {
        if (!this.attemptedParsing) {
            this.attemptedParsing = true;
            this.source.seek(this.topDictBeginOffset);
            while (this.source.getOffset() < this.topDictEndOffset) {
                this.readTopDictUnit();
            }
            this.stack.clear();
            this.source.seek(this.privateDictOffset);
            while (this.source.getOffset() < this.privateDictOffset + this.privateDictSize) {
                this.readPrivateDictUnit();
            }
            this.readLocalSubrsAndBias();
            this.source.seek(this.charStringsOffset);
            this.readCharStrings();
            this.source.seek(this.encodingOffset);
            this.readEncoding();
            this.source.seek(this.charSetOffset);
            this.readCharSet();
            this.readWidths();
            this.successfullyParsed = true;
        }
    }

    @Override
    protected void readTopDictOneByteOps(int lastRead) {
        switch (lastRead) {
            case 16: {
                this.encodingOffset = ((CFFNumber)this.stack.get(this.stack.size() - 1)).getInteger();
                this.stack.clear();
                break;
            }
            default: {
                this.stack.clear();
            }
        }
    }

    private void readEncoding() throws IOException {
        if (this.encodingOffset == 0L) {
            this.isStandardEncoding = true;
        } else if (this.encodingOffset == 1L) {
            this.isExpertEncoding = true;
        } else {
            int format = this.readCard8() & 0xFF;
            switch (format) {
                case 0: 
                case 128: {
                    int amount = this.readCard8() & 0xFF;
                    int i = 0;
                    while (i < amount) {
                        this.encoding[this.readCard8()] = i++;
                    }
                    if (format == 0) break;
                    this.readSupplements();
                    break;
                }
                case 1: 
                case 129: {
                    int amount = this.readCard8() & 0xFF;
                    int encodingPointer = 0;
                    for (int i = 0; i < amount; ++i) {
                        int first = this.readCard8() & 0xFF;
                        int nLeft = this.readCard8() & 0xFF;
                        for (int j = 0; j <= nLeft; ++j) {
                            if (first + j >= this.encoding.length) continue;
                            this.encoding[first + j] = encodingPointer++;
                        }
                    }
                    if (format == 1) break;
                    this.readSupplements();
                    break;
                }
            }
        }
    }

    private void readSupplements() throws IOException {
        int nSups = this.readCard8() & 0xFF;
        for (int i = 0; i < nSups; ++i) {
            int glyph;
            int code = this.readCard8() & 0xFF;
            this.encoding[code] = glyph = this.readCard16();
        }
    }

    private void readCharSet() throws IOException {
        this.charSet = new HashMap<String, Integer>();
        this.inverseCharSet = new HashMap<Integer, String>();
        this.charSet.put(this.getStringBySID(0), 0);
        this.inverseCharSet.put(0, this.getStringBySID(0));
        if (this.charSetOffset == 0L) {
            this.initializeCharSet(CFFPredefined.ISO_ADOBE_CHARSET);
        } else if (this.charSetOffset == 1L) {
            this.initializeCharSet(CFFPredefined.EXPERT_CHARSET);
        } else if (this.charSetOffset == 2L) {
            this.initializeCharSet(CFFPredefined.EXPERT_SUBSET_CHARSET);
        } else {
            int format = this.readCard8();
            switch (format) {
                case 0: {
                    for (int i = 1; i < this.nGlyphs; ++i) {
                        int sid = this.readCard16();
                        this.charSet.put(this.getStringBySID(sid), i);
                        this.inverseCharSet.put(i, this.getStringBySID(sid));
                    }
                    break;
                }
                case 1: 
                case 2: {
                    try {
                        int charSetPointer = 1;
                        while (charSetPointer < this.nGlyphs) {
                            int first = this.readCard16();
                            int nLeft = format == 1 ? this.readCard8() & 0xFF : this.readCard16();
                            for (int i = 0; i <= nLeft; ++i) {
                                this.charSet.put(this.getStringBySID(first + i), charSetPointer);
                                this.inverseCharSet.put(charSetPointer++, this.getStringBySID(first + i));
                            }
                        }
                        break;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new IOException("Error in parsing ranges of CharString in CFF file", e);
                    }
                }
                default: {
                    throw new IOException("Can't process format of CharSet in CFF file");
                }
            }
        }
    }

    private void readWidths() {
        CFFCharStringsHandler charStrings = new CFFCharStringsHandler(this.charStrings, this.charStringsOffset, this.source);
        this.widths = new CharStringsWidths(this.isSubset, this.charStringType, charStrings, this.fontMatrix, this.localSubrIndex, this.globalSubrs, this.bias, this.defaultWidthX, this.nominalWidthX);
    }

    @Override
    public String getGlyphName(int code) {
        if (this.isStandardEncoding) {
            if (code < CFFPredefined.STANDARD_ENCODING.length) {
                return CFFPredefined.STANDARD_STRINGS[CFFPredefined.STANDARD_ENCODING[code]];
            }
        } else if (this.isExpertEncoding) {
            if (code < CFFPredefined.EXPERT_ENCODING.length) {
                int sid = CFFPredefined.EXPERT_ENCODING[code];
                if (sid == 1) {
                    return CFFPredefined.EXPERT_CHARSET[1];
                }
                if (sid < CFFPredefined.ISO_ADOBE_CHARSET.length) {
                    return CFFPredefined.STANDARD_STRINGS[sid];
                }
                if (sid <= 378) {
                    return CFFPredefined.EXPERT_CHARSET[sid - CFFPredefined.ISO_ADOBE_CHARSET.length - 2];
                }
            }
        } else if (code < this.encoding.length) {
            return this.inverseCharSet.get(this.encoding[code] + 1);
        }
        return NOTDEF_STRING;
    }

    @Override
    public float getWidth(int charCode) {
        if (this.externalCMap != null) {
            int gid = this.externalCMap.toCID(charCode);
            float res = this.widths.getWidth(gid);
            if ((double)res != -1.0) {
                return res;
            }
            return this.widths.getWidth(0);
        }
        try {
            return this.getWidth(this.getGlyphName(charCode));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1.0f;
        }
    }

    public float getWidthFromGID(int gid) {
        return this.widths.getWidth(gid);
    }

    public boolean containsGID(int gid) {
        return gid >= 0 && this.charStrings.size() > gid;
    }

    @Override
    public boolean containsGlyph(String glyphName) {
        return this.charSet.keySet().contains(glyphName);
    }

    @Override
    public float getWidth(String charName) {
        Integer index = this.charSet.get(charName);
        if (index == null || index >= this.widths.getWidthsAmount() || index < 0) {
            return this.widths.getWidth(0);
        }
        return this.widths.getWidth(index);
    }

    @Override
    public boolean containsCode(int code) {
        return this.charSet.keySet().contains(this.getGlyphName(code));
    }

    @Override
    public boolean containsCID(int cid) {
        return false;
    }

    private void initializeCharSet(String[] charSetArray) {
        for (int i = 0; i < this.nGlyphs; ++i) {
            this.charSet.put(charSetArray[i], i);
            this.inverseCharSet.put(i, charSetArray[i]);
        }
    }

    public String[] getEncoding() {
        if (this.encodingStrings == null) {
            this.encodingStrings = new String[256];
            for (int i = 0; i < 256; ++i) {
                String glyphName = this.inverseCharSet.get(this.encoding[i]);
                this.encodingStrings[i] = glyphName == null ? NOTDEF_STRING : glyphName;
            }
            return this.encodingStrings;
        }
        return this.encodingStrings;
    }

    public Set<String> getCharSet() {
        return this.charSet.keySet();
    }

    @Override
    public boolean isAttemptedParsing() {
        return this.attemptedParsing;
    }

    @Override
    public boolean isSuccessfulParsing() {
        return this.successfullyParsed;
    }

    private void readLocalSubrsAndBias() throws IOException {
        if (this.subrsOffset != -1L) {
            long startOffset = this.source.getOffset();
            this.source.seek(this.subrsOffset);
            this.localSubrIndex = this.readIndex();
            this.source.seek(startOffset);
            int nSubrs = this.localSubrIndex.size();
            this.bias = this.charStringType == 1 ? 0 : (nSubrs < 1240 ? 107 : (nSubrs < 33900 ? 1131 : 32768));
        }
    }

    public static CFFType1FontProgram getCFFType1(FontProgram fontProgram) {
        FontProgram innerCFF;
        if (fontProgram instanceof CFFType1FontProgram) {
            return (CFFType1FontProgram)fontProgram;
        }
        if (fontProgram instanceof CFFFontProgram && (innerCFF = ((CFFFontProgram)fontProgram).getFont()) instanceof CFFType1FontProgram) {
            return (CFFType1FontProgram)innerCFF;
        }
        return null;
    }
}

