/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cff;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.pd.font.CFFNumber;
import org.verapdf.pd.font.cff.CFFIndex;
import org.verapdf.pd.font.cff.CFFPredefined;

class CFFFileBaseParser {
    protected SeekableInputStream source;
    protected CFFIndex definedNames;

    CFFFileBaseParser(ASInputStream source) throws IOException {
        this.source = SeekableInputStream.getSeekableStream(source);
    }

    CFFFileBaseParser(SeekableInputStream source) {
        this.source = source;
    }

    protected int readCard8() throws IOException {
        return this.source.readByte() & 0xFF;
    }

    protected int readCard16() throws IOException {
        int highOrder = (this.source.readByte() & 0xFF) << 8;
        return highOrder | this.source.readByte() & 0xFF;
    }

    private long readOffset(int offSize) throws IOException {
        long res = 0L;
        for (int i = 0; i < offSize - 1; ++i) {
            res |= (long)(this.source.readByte() & 0xFF);
            res <<= 8;
        }
        return res |= (long)(this.source.readByte() & 0xFF);
    }

    protected CFFIndex readIndex() throws IOException {
        int count = this.readCard16();
        if (count == 0) {
            return new CFFIndex(0, 0, new int[0], new byte[0]);
        }
        int offSize = this.readCard8();
        int[] offset = new int[count + 1];
        for (int i = 0; i < count + 1; ++i) {
            offset[i] = (int)this.readOffset(offSize);
        }
        byte[] data = new byte[offset[count] - 1];
        if (this.source.read(data, data.length) != data.length) {
            throw new IOException("End of stream is reached");
        }
        int offsetShift = 3 + offSize * (count + 1);
        return new CFFIndex(count, offsetShift, offset, data);
    }

    protected void readHeader() throws IOException {
        this.readCard8();
        this.readCard8();
        int hdrSize = this.readCard8();
        this.source.seek(hdrSize);
    }

    private float readReal() throws IOException {
        StringBuilder builder = new StringBuilder();
        block7: while (true) {
            int buf = this.readCard8();
            int[] hexs = new int[]{buf >> 4, buf & 0xF};
            int i = 0;
            while (true) {
                if (i >= 2) continue block7;
                if (hexs[i] < 10) {
                    builder.append(hexs[i]);
                } else {
                    switch (hexs[i]) {
                        case 10: {
                            builder.append('.');
                            break;
                        }
                        case 11: {
                            builder.append('E');
                            break;
                        }
                        case 12: {
                            builder.append("E-");
                            break;
                        }
                        case 14: {
                            builder.append('-');
                            break;
                        }
                        case 15: {
                            break block7;
                        }
                        default: {
                            break block7;
                        }
                    }
                }
                ++i;
            }
            break;
        }
        return Float.parseFloat(builder.toString());
    }

    private int readInteger(byte b) throws IOException {
        int firstByteValue = b & 0xFF;
        if (firstByteValue > 31 && firstByteValue < 247) {
            return firstByteValue - 139;
        }
        if (firstByteValue > 246 && firstByteValue < 251) {
            int first = firstByteValue - 247 << 8;
            return first + this.readCard8() + 108;
        }
        if (firstByteValue > 250 && firstByteValue < 255) {
            int first = firstByteValue - 251 << 8;
            return -first - this.readCard8() - 108;
        }
        if (firstByteValue == 28) {
            return this.readCard16();
        }
        if (firstByteValue == 29) {
            return this.readCard16() << 16 | this.readCard16();
        }
        throw new IOException("Can't read integer");
    }

    protected CFFNumber readNumber() throws IOException {
        byte first = this.source.readByte();
        if (first == 30) {
            return new CFFNumber(this.readReal());
        }
        return new CFFNumber(this.readInteger(first));
    }

    protected String getStringBySID(int sid) throws IOException {
        try {
            if (sid < CFFPredefined.N_STD_STRINGS) {
                return CFFPredefined.STANDARD_STRINGS[sid];
            }
            return new String(this.definedNames.get(sid - CFFPredefined.N_STD_STRINGS), StandardCharsets.ISO_8859_1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Can't get string with given SID", e);
        }
    }
}

