/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.verapdf.cos.COSNumber;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.visitor.ICOSVisitor;
import org.verapdf.cos.visitor.IVisitor;

public class COSReal
extends COSNumber {
    private static final NumberFormat FORMATTER = new DecimalFormat("#0.000000");
    private double value;

    protected COSReal() {
    }

    protected COSReal(double value) {
        this.value = value;
    }

    @Override
    public COSObjType getType() {
        return COSObjType.COS_REAL;
    }

    public static COSObject construct(double initValue) {
        return new COSObject(new COSReal(initValue));
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitFromReal(this);
    }

    @Override
    public Object accept(ICOSVisitor visitor) {
        return visitor.visitFromReal(this);
    }

    @Override
    public Long getInteger() {
        return (long)this.get();
    }

    public void setInteger(int value) {
        this.set(value);
    }

    @Override
    public Double getReal() {
        return this.get();
    }

    @Override
    public boolean setReal(double value) {
        this.set(value);
        return true;
    }

    public double get() {
        return this.value;
    }

    public void set(double value) {
        this.value = value;
    }

    public String toString() {
        String stringValue = FORMATTER.format(this.value);
        if (stringValue.indexOf(46) > -1 && !stringValue.endsWith(".0")) {
            while (stringValue.endsWith("0") && !stringValue.endsWith(".0")) {
                stringValue = stringValue.substring(0, stringValue.length() - 1);
            }
        }
        return stringValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof COSReal)) {
            return false;
        }
        COSReal cosReal = (COSReal)o;
        return Double.compare(cosReal.value, this.value) == 0;
    }
}

