/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.features.objects.PageFeaturesObjectAdapter;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pd.PDPage;

public class GFPageFeaturesObjectAdapter
implements PageFeaturesObjectAdapter {
    private PDPage page;
    private String label;
    private String thumb;
    private Set<String> annotsId;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> propertiesChild;
    private int index;
    private String transitionStyle;
    private List<String> errors;

    public GFPageFeaturesObjectAdapter(PDPage page, String label, String thumb, Set<String> annotsId, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> propertiesChild, int index) {
        COSObject transition;
        this.page = page;
        this.label = label;
        this.thumb = thumb;
        this.annotsId = annotsId;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.propertiesChild = propertiesChild;
        this.index = index;
        if (this.page != null && !this.page.empty() && (transition = page.getKey(ASAtom.TRANS)) != null && !transition.empty()) {
            if (transition.getType() == COSObjType.COS_DICT) {
                ASAtom style = transition.getNameKey(ASAtom.S);
                this.transitionStyle = style == null ? "R" : style.getValue();
            } else {
                this.errors = new ArrayList<String>();
                this.errors.add("Page dictionary contains /Trans key but its value's type is not a dictionary");
            }
        }
    }

    public String getThumb() {
        return this.thumb;
    }

    public Set<String> getAnnotsId() {
        return this.annotsId;
    }

    public Set<String> getExtGStateChild() {
        return this.extGStateChild;
    }

    public Set<String> getColorSpaceChild() {
        return this.colorSpaceChild;
    }

    public Set<String> getPatternChild() {
        return this.patternChild;
    }

    public Set<String> getShadingChild() {
        return this.shadingChild;
    }

    public Set<String> getXObjectChild() {
        return this.xobjectChild;
    }

    public Set<String> getFontChild() {
        return this.fontChild;
    }

    public Set<String> getPropertiesChild() {
        return this.propertiesChild;
    }

    public int getIndex() {
        return this.index;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTransitionStyle() {
        return this.transitionStyle;
    }

    public double[] getMediaBox() {
        if (this.page != null && !this.page.empty()) {
            return this.page.getMediaBox();
        }
        return null;
    }

    public double[] getCropBox() {
        if (this.page != null && !this.page.empty()) {
            return this.page.getCropBox();
        }
        return null;
    }

    public double[] getTrimBox() {
        if (this.page != null && !this.page.empty()) {
            return this.page.getTrimBox();
        }
        return null;
    }

    public double[] getBleedBox() {
        if (this.page != null && !this.page.empty()) {
            return this.page.getBleedBox();
        }
        return null;
    }

    public double[] getArtBox() {
        if (this.page != null && !this.page.empty()) {
            return this.page.getArtBox();
        }
        return null;
    }

    public Long getRotation() {
        if (this.page != null && !this.page.empty()) {
            return this.page.getRotation();
        }
        return null;
    }

    public Double getScaling() {
        if (this.page != null && !this.page.empty()) {
            return this.page.getScaling();
        }
        return null;
    }

    public InputStream getMetadataStream() {
        PDMetadata meta;
        if (this.page != null && !this.page.empty() && (meta = this.page.getMetadata()) != null && !meta.empty()) {
            return meta.getStream();
        }
        return null;
    }

    public boolean isPDFObjectPresent() {
        return this.page != null && !this.page.empty();
    }

    public List<String> getErrors() {
        if (this.errors != null) {
            return Collections.unmodifiableList(this.errors);
        }
        return Collections.emptyList();
    }
}

