/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.features.objects.ImageXObjectFeaturesObjectAdapter;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pd.images.PDXImage;

public class GFImageXObjectFeaturesObjectAdapter
implements ImageXObjectFeaturesObjectAdapter {
    private PDXImage imageXObject;
    private String id;
    private String colorSpaceChild;
    private String maskChild;
    private String sMaskChild;
    private Set<String> alternatesChild;

    public GFImageXObjectFeaturesObjectAdapter(PDXImage imageXObject, String id, String colorSpaceChild, String maskChild, String sMaskChild, Set<String> alternatesChild) {
        this.imageXObject = imageXObject;
        this.id = id;
        this.colorSpaceChild = colorSpaceChild;
        this.maskChild = maskChild;
        this.sMaskChild = sMaskChild;
        this.alternatesChild = alternatesChild;
    }

    public String getID() {
        return this.id;
    }

    public Long getWidth() {
        return this.imageXObject == null || this.imageXObject.empty() ? null : this.imageXObject.getWidth();
    }

    public Long getHeight() {
        return this.imageXObject == null || this.imageXObject.empty() ? null : this.imageXObject.getHeight();
    }

    public String getColorSpaceChild() {
        return this.colorSpaceChild;
    }

    public Long getBitsPerComponent() {
        return this.imageXObject == null || this.imageXObject.empty() ? null : this.imageXObject.getBitsPerComponent();
    }

    public boolean getImageMask() {
        return this.imageXObject == null || this.imageXObject.empty() ? false : this.imageXObject.getImageMask();
    }

    public String getMaskChild() {
        return this.maskChild;
    }

    public boolean isInterpolate() {
        return this.imageXObject == null || this.imageXObject.empty() ? false : this.imageXObject.isInterpolate();
    }

    public Set<String> getAlternatesChild() {
        return this.alternatesChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.alternatesChild);
    }

    public String getSMaskChild() {
        return this.sMaskChild;
    }

    public Long getStructParent() {
        return this.imageXObject == null || this.imageXObject.empty() ? null : this.imageXObject.getStructParent();
    }

    public List<String> getFilters() {
        if (this.imageXObject != null) {
            List atomFilters = this.imageXObject.getFilters();
            ArrayList<String> res = new ArrayList<String>(atomFilters.size());
            for (ASAtom filter : atomFilters) {
                res.add(filter.getValue());
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    public InputStream getMetadata() {
        if (this.imageXObject != null && !this.imageXObject.empty()) {
            PDMetadata metadata = this.imageXObject.getMetadata();
            return metadata == null ? null : metadata.getStream();
        }
        return null;
    }

    public InputStream getRawStreamData() {
        if (this.imageXObject != null && !this.imageXObject.empty()) {
            return this.imageXObject.getObject().getData();
        }
        return null;
    }

    public List<ImageXObjectFeaturesObjectAdapter.StreamFilterAdapter> getFilterAdapters() {
        if (this.imageXObject != null && !this.imageXObject.empty()) {
            COSObject base = this.imageXObject.getKey(ASAtom.DECODE_PARMS);
            ArrayList<GFStreamFilterAdapter> res = new ArrayList<GFStreamFilterAdapter>();
            if (base != null) {
                if (base.getType() == COSObjType.COS_DICT) {
                    res.add(new GFStreamFilterAdapter(base));
                } else if (base.getType() == COSObjType.COS_ARRAY) {
                    for (COSObject baseElem : (COSArray)base.getDirectBase()) {
                        if (baseElem.getType() == COSObjType.COS_DICT) {
                            res.add(new GFStreamFilterAdapter(baseElem));
                            continue;
                        }
                        res.add(null);
                    }
                }
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    public boolean isPDFObjectPresent() {
        return this.imageXObject != null && !this.imageXObject.empty();
    }

    public List<String> getErrors() {
        return Collections.emptyList();
    }

    private class GFStreamFilterAdapter
    implements ImageXObjectFeaturesObjectAdapter.StreamFilterAdapter {
        private COSObject base;

        GFStreamFilterAdapter(COSObject base) {
            this.base = base == null ? COSObject.getEmpty() : base;
        }

        public Long getCCITTK() {
            return this.base.getIntegerKey(ASAtom.K);
        }

        public boolean getCCITTEndOfLine() {
            return this.base.getBooleanKey(ASAtom.COLORS);
        }

        public boolean getCCITTEncodedByteAlign() {
            return this.base.getBooleanKey(ASAtom.BITS_PER_COMPONENT);
        }

        public Long getCCITTColumns() {
            return this.base.getIntegerKey(ASAtom.COLUMNS);
        }

        public Long getCCITTRows() {
            return this.base.getIntegerKey(ASAtom.ROWS);
        }

        public boolean getCCITTEndOfBlock() {
            return this.base.getBooleanKey(ASAtom.getASAtom((String)"EndOfBlock"));
        }

        public boolean getCCITTBlackIs1() {
            return this.base.getBooleanKey(ASAtom.BLACK_IS_1);
        }

        public Long getCCITTDamagedRowsBeforeError() {
            return this.base.getIntegerKey(ASAtom.getASAtom((String)"DamagedRowsBeforeError"));
        }

        public Long getDCTColorTransform() {
            return this.base.getIntegerKey(ASAtom.getASAtom((String)"ColorTransform"));
        }

        public Long getLZWEarlyChange() {
            return this.base.getIntegerKey(ASAtom.EARLY_CHANGE);
        }

        public Long getFlatePredictor() {
            return this.base.getIntegerKey(ASAtom.PREDICTOR);
        }

        public Long getFlateColors() {
            return this.base.getIntegerKey(ASAtom.COLORS);
        }

        public Long getFlateBitsPerComponent() {
            return this.base.getIntegerKey(ASAtom.BITS_PER_COMPONENT);
        }

        public Long getFlateColumns() {
            return this.base.getIntegerKey(ASAtom.COLUMNS);
        }

        public InputStream getJBIG2Global() {
            COSObject globals = this.base.getKey(ASAtom.JBIG2_GLOBALS);
            if (globals.getType() == COSObjType.COS_STREAM) {
                return globals.getData(COSStream.FilterFlags.DECODE);
            }
            return null;
        }

        public boolean hasCryptFilter() {
            return !ASAtom.IDENTITY.equals((Object)this.base.getNameKey(ASAtom.NAME));
        }
    }
}

