/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.mockbehavior.impl;

import java.util.Arrays;
import org.unitils.core.UnitilsException;
import org.unitils.mock.Mock;
import org.unitils.mock.core.proxy.ProxyInvocation;
import org.unitils.mock.core.proxy.StackTraceUtils;
import org.unitils.mock.mockbehavior.ValidatableMockBehavior;

public class ExceptionThrowingMockBehavior
implements ValidatableMockBehavior {
    private Throwable exceptionToThrow;

    public ExceptionThrowingMockBehavior(Throwable exceptionToThrow) {
        this.exceptionToThrow = exceptionToThrow;
    }

    public void assertCanExecute(ProxyInvocation proxyInvocation) throws UnitilsException {
        Object[] exceptionTypes;
        if (this.exceptionToThrow instanceof RuntimeException || this.exceptionToThrow instanceof Error) {
            return;
        }
        for (Class<?> clazz : exceptionTypes = proxyInvocation.getMethod().getExceptionTypes()) {
            if (!clazz.isAssignableFrom(this.exceptionToThrow.getClass())) continue;
            return;
        }
        throw new UnitilsException("Trying to make a method throw an exception that it doesn't declare. Exception type: " + this.exceptionToThrow.getClass() + (exceptionTypes.length > 0 ? ", declared exceptions: " + Arrays.toString(exceptionTypes) : ", no declared exceptions"));
    }

    public Object execute(ProxyInvocation proxyInvocation) throws Throwable {
        this.exceptionToThrow.setStackTrace(StackTraceUtils.getInvocationStackTrace(Mock.class, false));
        throw this.exceptionToThrow;
    }
}

