/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.script;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.unitils.core.UnitilsException;
import org.unitils.dbmaintainer.script.ScriptContentHandle;
import org.unitils.dbmaintainer.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Script
implements Comparable<Script> {
    private String fileName;
    private Version version;
    private Long fileLastModifiedAt;
    private String checkSum;
    private ScriptContentHandle scriptContentHandle;

    public Script(String fileName, Long fileLastModifiedAt, ScriptContentHandle scriptContentHandle) {
        this.fileName = fileName;
        this.version = this.getVersionFromPath(fileName);
        this.fileLastModifiedAt = fileLastModifiedAt;
        this.scriptContentHandle = scriptContentHandle;
    }

    public Script(String fileName, Long fileLastModifiedAt, String checkSum) {
        this.fileName = fileName;
        this.version = this.getVersionFromPath(fileName);
        this.fileLastModifiedAt = fileLastModifiedAt;
        this.checkSum = checkSum;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Long getFileLastModifiedAt() {
        return this.fileLastModifiedAt;
    }

    public String getCheckSum() {
        if (this.checkSum == null) {
            this.checkSum = this.scriptContentHandle.getCheckSum();
        }
        return this.checkSum;
    }

    public Version getVersion() {
        return this.version;
    }

    public ScriptContentHandle getScriptContentHandle() {
        if (this.scriptContentHandle == null) {
            throw new UnitilsException("Script content is not available");
        }
        return this.scriptContentHandle;
    }

    public boolean isScriptContentEqualTo(Script other, boolean useLastModificationDates) {
        if (useLastModificationDates && this.getFileLastModifiedAt().equals(other.getFileLastModifiedAt())) {
            return true;
        }
        return this.getCheckSum().equals(other.getCheckSum());
    }

    public boolean isIncremental() {
        return this.version.getScriptIndex() != null;
    }

    @Override
    public int compareTo(Script script) {
        return this.version.compareTo(script.getVersion());
    }

    protected Version createVersion(List<Long> parentIndexes, File scriptFile) {
        ArrayList<Long> indexes = new ArrayList<Long>();
        indexes.addAll(parentIndexes);
        indexes.add(this.extractIndex(scriptFile.getName()));
        return new Version(indexes);
    }

    protected Version getVersionFromPath(String relativePath) {
        String[] pathParts = StringUtils.split((String)relativePath, (char)'/');
        ArrayList<Long> versionIndexes = new ArrayList<Long>();
        for (String pathPart : pathParts) {
            versionIndexes.add(this.extractIndex(pathPart));
        }
        return new Version(versionIndexes);
    }

    protected Long extractIndex(String pathPart) {
        if (StringUtils.contains((String)pathPart, (String)"_")) {
            try {
                return Long.parseLong(StringUtils.substringBefore((String)pathPart, (String)"_"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Script other = (Script)obj;
        return !(this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName));
    }

    public String toString() {
        return this.fileName;
    }
}

