/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.uberfire.ext.security.server.SecureHeadersConfig;

public class SecureHeadersFilter
implements Filter {
    public static final String LOCATION = "Location";
    public static final String STRICT_TRANSPORT_SECURITY = "Strict-Transport-Security";
    public static final String X_FRAME_OPTIONS = "X-FRAME-OPTIONS";
    public static final String X_XSS_OPTIONS = "X-XSS-Protection";
    private SecureHeadersConfig config;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = new SecureHeadersConfig(filterConfig);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        this.addLocation(response);
        this.addFrameOptions(response);
        this.addXSSOptions(response);
        if (request.getScheme().equals("https")) {
            this.addStrictTransportSecurity(response);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void addStrictTransportSecurity(HttpServletResponse response) {
        if (this.config.hasMaxAge()) {
            response.addHeader(STRICT_TRANSPORT_SECURITY, this.config.getMaxAge());
        }
    }

    private void addFrameOptions(HttpServletResponse response) {
        if (this.config.hasFrameOptions()) {
            response.addHeader(X_FRAME_OPTIONS, this.config.getFrameOptions());
        }
    }

    private void addLocation(HttpServletResponse response) {
        if (this.config.hasLocation()) {
            response.addHeader(LOCATION, this.config.getLocation());
            response.setStatus(301);
        }
    }

    private void addXSSOptions(HttpServletResponse response) {
        if (this.config.hasXSSOptions()) {
            response.addHeader(X_XSS_OPTIONS, this.config.getXssOptions());
        }
    }
}

