/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Named;
import org.jboss.errai.security.shared.api.Role;
import org.uberfire.backend.server.security.RoleRegistry;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.ContextualManager;
import org.uberfire.ext.security.management.api.RoleManager;
import org.uberfire.ext.security.management.api.RoleManagerSettings;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.search.RolesRuntimeSearchEngine;
import org.uberfire.ext.security.management.search.RuntimeSearchEngine;

@Dependent
@Named(value="uberfireRoleManager")
public class UberfireRoleManager
implements RoleManager,
ContextualManager {
    UserSystemManager userSystemManager;
    RuntimeSearchEngine<Role> rolesSearchEngine;

    public void initialize(UserSystemManager userSystemManager) throws Exception {
        this.userSystemManager = userSystemManager;
        this.rolesSearchEngine = new RolesRuntimeSearchEngine();
    }

    public AbstractEntityManager.SearchResponse<Role> search(AbstractEntityManager.SearchRequest request) throws SecurityManagementException {
        return this.rolesSearchEngine.search(RoleRegistry.get().getRegisteredRoles(), request);
    }

    public Role get(String identifier) throws SecurityManagementException {
        return RoleRegistry.get().getRegisteredRole(identifier);
    }

    public List<Role> getAll() throws SecurityManagementException {
        return new ArrayList<Role>(RoleRegistry.get().getRegisteredRoles());
    }

    public Role create(Role entity) throws SecurityManagementException {
        throw new UnsupportedOperationException("Create operation is not available when using the UberfireRoleManager provider.");
    }

    public Role update(Role entity) throws SecurityManagementException {
        throw new UnsupportedOperationException("Update operation is not available when using the UberfireRoleManager provider.");
    }

    public void delete(String ... identifiers) throws SecurityManagementException {
        throw new UnsupportedOperationException("Delete operation is not available when using the UberfireRoleManager provider.");
    }

    public RoleManagerSettings getSettings() {
        return null;
    }

    public void destroy() throws Exception {
    }
}

