/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.backend.server.security.RoleRegistry;
import org.uberfire.ext.security.management.util.SecurityManagementUtils;

public class SecurityManagementUtilsTest {
    @BeforeClass
    public static void setup() throws IOException {
        RoleRegistry.get().clear();
    }

    @Test
    public void testCreateGroup() {
        String testId = "id1";
        Group group = SecurityManagementUtils.createGroup((String)"id1");
        Assert.assertNotNull((Object)group);
        String name = group.getName();
        Assert.assertEquals((Object)name, (Object)"id1");
    }

    @Test
    public void testCreateRole() {
        String testId = "id1";
        Role role = SecurityManagementUtils.createRole((String)"id1");
        Assert.assertNotNull((Object)role);
        String name = role.getName();
        Assert.assertEquals((Object)name, (Object)"id1");
    }

    @Test
    public void testCreateUserWithId() {
        String testId = "id1";
        User user = SecurityManagementUtils.createUser((String)"id1");
        Assert.assertNotNull((Object)user);
        String id = user.getIdentifier();
        Assert.assertEquals((Object)id, (Object)"id1");
    }

    @Test
    public void testCreateUserWithIdNull() {
        String testId = null;
        Assert.assertNull((Object)SecurityManagementUtils.createUser(testId));
    }

    @Test
    public void testCreateUserWithGroups() {
        String testId = "id1";
        String group1Id = "g1";
        String group2Id = "g2";
        Group group1 = SecurityManagementUtils.createGroup((String)"g1");
        Group group2 = SecurityManagementUtils.createGroup((String)"g2");
        HashSet<Group> groups = new HashSet<Group>(2);
        groups.add(group1);
        groups.add(group2);
        User user = SecurityManagementUtils.createUser((String)"id1", groups);
        Assert.assertNotNull((Object)user);
        String id = user.getIdentifier();
        Assert.assertEquals((Object)id, (Object)"id1");
        Set resultGroups = user.getGroups();
        Assert.assertNotNull((Object)resultGroups);
        Assert.assertTrue((resultGroups.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)resultGroups, groups);
    }

    @Test
    public void testCreateUserWithGroupsAndRoles() {
        String testId = "id1";
        String group1Id = "g1";
        String group2Id = "g2";
        String role1Id = "r1";
        String role2Id = "r2";
        Group group1 = SecurityManagementUtils.createGroup((String)"g1");
        Group group2 = SecurityManagementUtils.createGroup((String)"g2");
        HashSet<Group> groups = new HashSet<Group>(2);
        groups.add(group1);
        groups.add(group2);
        Role role1 = SecurityManagementUtils.createRole((String)"r1");
        Role role2 = SecurityManagementUtils.createRole((String)"r2");
        HashSet<Role> roles = new HashSet<Role>(2);
        roles.add(role1);
        roles.add(role2);
        User user = SecurityManagementUtils.createUser((String)"id1", groups, roles);
        Assert.assertNotNull((Object)user);
        String id = user.getIdentifier();
        Assert.assertEquals((Object)id, (Object)"id1");
        Set resultGroups = user.getGroups();
        Assert.assertNotNull((Object)resultGroups);
        Assert.assertTrue((resultGroups.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)resultGroups, groups);
        Set resultRoles = user.getRoles();
        Assert.assertNotNull((Object)resultRoles);
        Assert.assertTrue((resultRoles.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)resultRoles, roles);
    }

    @Test
    public void testCreateUserWithGroupsAndRolesAndProperties() {
        String testId = "id1";
        String group1Id = "g1";
        String group2Id = "g2";
        String role1Id = "r1";
        String role2Id = "r2";
        Group group1 = SecurityManagementUtils.createGroup((String)"g1");
        Group group2 = SecurityManagementUtils.createGroup((String)"g2");
        HashSet<Group> groups = new HashSet<Group>(2);
        groups.add(group1);
        groups.add(group2);
        Role role1 = SecurityManagementUtils.createRole((String)"r1");
        Role role2 = SecurityManagementUtils.createRole((String)"r2");
        HashSet<Role> roles = new HashSet<Role>(2);
        roles.add(role1);
        roles.add(role2);
        HashMap<String, String> props = new HashMap<String, String>(2);
        props.put("p1", "value1");
        props.put("p2", "value2");
        User user = SecurityManagementUtils.createUser((String)"id1", groups, roles, props);
        Assert.assertNotNull((Object)user);
        String id = user.getIdentifier();
        Assert.assertEquals((Object)id, (Object)"id1");
        Set resultGroups = user.getGroups();
        Assert.assertNotNull((Object)resultGroups);
        Assert.assertTrue((resultGroups.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)resultGroups, groups);
        Set resultRoles = user.getRoles();
        Assert.assertNotNull((Object)resultRoles);
        Assert.assertTrue((resultRoles.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)resultRoles, roles);
        Map resultProps = user.getProperties();
        Assert.assertNotNull((Object)resultProps);
        Assert.assertTrue((resultProps.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals(resultProps.get("p1"), (Object)"value1");
        Assert.assertEquals(resultProps.get("p2"), (Object)"value2");
    }

    @Test
    public void testCloneUser() {
        String testId = "id1";
        String group1Id = "g1";
        String group2Id = "g2";
        String role1Id = "r1";
        String role2Id = "r2";
        Group group1 = SecurityManagementUtils.createGroup((String)"g1");
        Group group2 = SecurityManagementUtils.createGroup((String)"g2");
        HashSet<Group> groups = new HashSet<Group>(2);
        groups.add(group1);
        groups.add(group2);
        Role role1 = SecurityManagementUtils.createRole((String)"r1");
        Role role2 = SecurityManagementUtils.createRole((String)"r2");
        HashSet<Role> roles = new HashSet<Role>(2);
        roles.add(role1);
        roles.add(role2);
        HashMap<String, String> props = new HashMap<String, String>(2);
        props.put("p1", "value1");
        props.put("p2", "value2");
        User user = SecurityManagementUtils.createUser((String)"id1", groups, roles, props);
        User cloned = SecurityManagementUtils.clone((User)user);
        Assert.assertNotNull((Object)cloned);
        String id = cloned.getIdentifier();
        Assert.assertEquals((Object)id, (Object)"id1");
        Set resultGroups = cloned.getGroups();
        Assert.assertNotNull((Object)resultGroups);
        Assert.assertTrue((resultGroups.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)resultGroups, groups);
        Set resultRoles = cloned.getRoles();
        Assert.assertNotNull((Object)resultRoles);
        Assert.assertTrue((resultRoles.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)resultRoles, roles);
        Map resultProps = cloned.getProperties();
        Assert.assertNotNull((Object)resultProps);
        Assert.assertTrue((resultProps.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals(resultProps.get("p1"), (Object)"value1");
        Assert.assertEquals(resultProps.get("p2"), (Object)"value2");
    }

    @Test
    public void testGetRegisteredRoles() {
        RoleRegistry.get().registerRole("role1");
        RoleRegistry.get().registerRole("role2");
        Set roles = SecurityManagementUtils.getRegisteredRoles();
        Assert.assertNotNull((Object)roles);
        Assert.assertTrue((roles.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)roles.contains(new RoleImpl("admin")));
    }

    @Test
    public void testGetRegisteredRoleNames() {
        RoleRegistry.get().registerRole("role1");
        RoleRegistry.get().registerRole("role2");
        Set roles = SecurityManagementUtils.getRegisteredRoleNames();
        Assert.assertNotNull((Object)roles);
        Assert.assertTrue((roles.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)roles.contains("admin"));
    }

    @Test
    public void testRolesToString() {
        HashSet<Role> roles = new HashSet<Role>(2);
        Role role1 = (Role)Mockito.mock(Role.class);
        Mockito.when((Object)role1.getName()).thenReturn((Object)"role1");
        Role role2 = (Role)Mockito.mock(Role.class);
        Mockito.when((Object)role2.getName()).thenReturn((Object)"role2");
        roles.add(role1);
        roles.add(role2);
        Set rolesStr = SecurityManagementUtils.rolesToString(roles);
        Assert.assertNotNull((Object)rolesStr);
        Assert.assertTrue((rolesStr.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rolesStr.contains("role1"));
        Assert.assertTrue((boolean)rolesStr.contains("role2"));
    }

    @Test
    public void testRolesToStringEmpty() {
        Set rolesStr = SecurityManagementUtils.rolesToString(null);
        Assert.assertNotNull((Object)rolesStr);
        Assert.assertTrue((rolesStr.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGroupsToString() {
        HashSet<Group> roles = new HashSet<Group>(2);
        Group role1 = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)role1.getName()).thenReturn((Object)"group1");
        Group role2 = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)role2.getName()).thenReturn((Object)"group2");
        roles.add(role1);
        roles.add(role2);
        Set rolesStr = SecurityManagementUtils.groupsToString(roles);
        Assert.assertNotNull((Object)rolesStr);
        Assert.assertTrue((rolesStr.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rolesStr.contains("group1"));
        Assert.assertTrue((boolean)rolesStr.contains("group2"));
    }

    @Test
    public void testGroupsToStringEmpty() {
        Set rolesStr = SecurityManagementUtils.groupsToString(null);
        Assert.assertNotNull((Object)rolesStr);
        Assert.assertTrue((rolesStr.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPopulateGroupsOrRoles() {
        RoleRegistry.get().registerRole("role1");
        Set registeredRoles = SecurityManagementUtils.getRegisteredRoleNames();
        HashSet groups = new HashSet();
        HashSet roles = new HashSet();
        SecurityManagementUtils.populateGroupOrRoles((String)"group1", (Set)registeredRoles, groups, roles);
        Assert.assertTrue((groups.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)roles.isEmpty());
        SecurityManagementUtils.populateGroupOrRoles((String)"role1", (Set)registeredRoles, groups, roles);
        Assert.assertTrue((groups.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((roles.size() == 1 ? 1 : 0) != 0);
    }
}

