/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.authz.PermissionType;
import org.uberfire.security.authz.PermissionTypeRegistry;
import org.uberfire.security.authz.VotingAlgorithm;
import org.uberfire.security.authz.VotingStrategy;
import org.uberfire.security.impl.authz.AffirmativeBasedVoter;
import org.uberfire.security.impl.authz.AuthorizationPolicyBuilder;
import org.uberfire.security.impl.authz.ConsensusBasedVoter;
import org.uberfire.security.impl.authz.DefaultAuthorizationPolicy;
import org.uberfire.security.impl.authz.DefaultAuthzResultCache;
import org.uberfire.security.impl.authz.DefaultPermissionCollection;
import org.uberfire.security.impl.authz.DefaultPermissionTypeRegistry;
import org.uberfire.security.impl.authz.UnanimousBasedVoter;

@ApplicationScoped
public class DefaultPermissionManager
implements PermissionManager {
    private PermissionTypeRegistry permissionTypeRegistry;
    private AuthorizationPolicy authorizationPolicy = new DefaultAuthorizationPolicy();
    private DefaultAuthzResultCache cache;
    private VotingStrategy defaultVotingStrategy = VotingStrategy.PRIORITY;
    private Map<VotingStrategy, VotingAlgorithm> votingAlgorithmMap = new HashMap<VotingStrategy, VotingAlgorithm>();

    @Inject
    public DefaultPermissionManager(PermissionTypeRegistry permissionTypeRegistry) {
        this(permissionTypeRegistry, new DefaultAuthzResultCache());
    }

    public DefaultPermissionManager() {
        this(new DefaultPermissionTypeRegistry(), new DefaultAuthzResultCache());
    }

    public DefaultPermissionManager(PermissionTypeRegistry permissionTypeRegistry, DefaultAuthzResultCache cache) {
        this.permissionTypeRegistry = permissionTypeRegistry;
        this.cache = cache;
        this.setVotingAlgorithm(VotingStrategy.AFFIRMATIVE, new AffirmativeBasedVoter());
        this.setVotingAlgorithm(VotingStrategy.CONSENSUS, new ConsensusBasedVoter());
        this.setVotingAlgorithm(VotingStrategy.UNANIMOUS, new UnanimousBasedVoter());
    }

    @Override
    public AuthorizationPolicy getAuthorizationPolicy() {
        return this.authorizationPolicy;
    }

    @Override
    public void setAuthorizationPolicy(AuthorizationPolicy authorizationPolicy) {
        this.authorizationPolicy = authorizationPolicy != null ? authorizationPolicy : new DefaultAuthorizationPolicy();
        this.cache.clear();
    }

    @Override
    public AuthorizationPolicyBuilder newAuthorizationPolicy() {
        return new AuthorizationPolicyBuilder(this.permissionTypeRegistry);
    }

    @Override
    public VotingStrategy getDefaultVotingStrategy() {
        return this.defaultVotingStrategy;
    }

    @Override
    public void setDefaultVotingStrategy(VotingStrategy votingStrategy) {
        this.defaultVotingStrategy = votingStrategy;
    }

    @Override
    public VotingAlgorithm getVotingAlgorithm(VotingStrategy votingStrategy) {
        return this.votingAlgorithmMap.get(votingStrategy);
    }

    @Override
    public void setVotingAlgorithm(VotingStrategy votingStrategy, VotingAlgorithm votingAlgorithm) {
        this.votingAlgorithmMap.put(votingStrategy, votingAlgorithm);
    }

    @Override
    public Permission createPermission(String name, boolean granted) {
        PermissionType permissionType = this.permissionTypeRegistry.resolve(name);
        return permissionType.createPermission(name, granted);
    }

    @Override
    public Permission createPermission(Resource resource, ResourceAction action, boolean granted) {
        if (resource.getResourceType() != null && !resource.isType(ResourceType.UNKNOWN.getName())) {
            PermissionType permissionType = this.permissionTypeRegistry.resolve(resource.getResourceType().getName());
            return permissionType.createPermission(resource, action, granted);
        }
        return this.createPermission(resource.getIdentifier(), granted);
    }

    @Override
    public Permission createPermission(ResourceType resourceType, ResourceAction action, boolean granted) {
        PermissionType permissionType = this.permissionTypeRegistry.resolve(resourceType.getName());
        return permissionType.createPermission(resourceType, action, granted);
    }

    @Override
    public AuthorizationResult checkPermission(Permission permission, User user) {
        return this.checkPermission(permission, user, this.defaultVotingStrategy);
    }

    @Override
    public AuthorizationResult checkPermission(Permission permission, User user, VotingStrategy votingStrategy) {
        if (this.authorizationPolicy == null || permission == null) {
            return AuthorizationResult.ACCESS_ABSTAIN;
        }
        AuthorizationResult result = this.cache.get(user, permission);
        if (result == null) {
            result = this._checkPermission(permission, user, votingStrategy == null ? this.defaultVotingStrategy : votingStrategy);
            this.cache.put(user, permission, result);
        }
        return result;
    }

    protected AuthorizationResult _checkPermission(Permission permission, User user, VotingStrategy votingStrategy) {
        if (VotingStrategy.PRIORITY.equals((Object)votingStrategy)) {
            PermissionCollection userPermissions = this.resolvePermissions(user, VotingStrategy.PRIORITY);
            return this._checkPermission(permission, userPermissions);
        }
        List<AuthorizationResult> permList = this._checkRoleAndGroupPermissions(permission, user);
        VotingAlgorithm votingAlgorithm = this.votingAlgorithmMap.get(votingStrategy);
        return votingAlgorithm.vote(permList);
    }

    protected List<AuthorizationResult> _checkRoleAndGroupPermissions(Permission permission, User user) {
        AuthorizationResult _partialResult;
        PermissionCollection collection;
        ArrayList<AuthorizationResult> result = new ArrayList<AuthorizationResult>();
        if (user.getRoles() != null) {
            for (Role role : user.getRoles()) {
                collection = this.authorizationPolicy.getPermissions(role);
                _partialResult = this._checkPermission(permission, collection);
                result.add(_partialResult);
            }
        }
        if (user.getGroups() != null) {
            for (Group group : user.getGroups()) {
                collection = this.authorizationPolicy.getPermissions(group);
                _partialResult = this._checkPermission(permission, collection);
                result.add(_partialResult);
            }
        }
        return result;
    }

    protected AuthorizationResult _checkPermission(Permission permission, PermissionCollection collection) {
        if (collection == null) {
            return AuthorizationResult.ACCESS_ABSTAIN;
        }
        Permission existing = collection.get(permission.getName());
        if (existing != null) {
            return existing.getResult().equals((Object)permission.getResult()) ? AuthorizationResult.ACCESS_GRANTED : AuthorizationResult.ACCESS_DENIED;
        }
        if (collection.implies(permission)) {
            return AuthorizationResult.ACCESS_GRANTED;
        }
        Permission inverted = permission.clone();
        inverted.setResult(inverted.getResult().invert());
        if (collection.implies(inverted)) {
            return AuthorizationResult.ACCESS_DENIED;
        }
        return AuthorizationResult.ACCESS_ABSTAIN;
    }

    @Override
    public String resolveResourceId(Permission permission) {
        PermissionType permissionType = this.permissionTypeRegistry.resolve(permission.getName());
        return permissionType.resolveResourceId(permission);
    }

    @Override
    public PermissionCollection resolvePermissions(User user, VotingStrategy votingStrategy) {
        if (user == null) {
            return new DefaultPermissionCollection();
        }
        switch (votingStrategy) {
            case AFFIRMATIVE: {
                return this.resolvePermissionsAffirmative(user);
            }
            case CONSENSUS: {
                return this.resolvePermissionsConsensus(user);
            }
            case UNANIMOUS: {
                return this.resolvePermissionsUnanimous(user);
            }
        }
        return this.resolvePermissionsPriority(user);
    }

    private PermissionCollection resolvePermissionsAffirmative(User user) {
        DefaultPermissionCollection result = new DefaultPermissionCollection();
        return result;
    }

    private PermissionCollection resolvePermissionsConsensus(User user) {
        DefaultPermissionCollection result = new DefaultPermissionCollection();
        return result;
    }

    private PermissionCollection resolvePermissionsUnanimous(User user) {
        DefaultPermissionCollection result = new DefaultPermissionCollection();
        return result;
    }

    private PermissionCollection resolvePermissionsPriority(User user) {
        if (this.authorizationPolicy == null) {
            return null;
        }
        PermissionCollection result = this.authorizationPolicy.getPermissions();
        int[] priority = new int[]{Integer.MIN_VALUE};
        result = this.mergeRolePermissions(user, result, priority);
        result = this.mergeGroupPermissions(user, result, priority);
        return result;
    }

    private PermissionCollection mergeRolePermissions(User user, PermissionCollection target, int[] lastPriority) {
        PermissionCollection result = target;
        if (user.getRoles() != null) {
            for (Role role : user.getRoles()) {
                PermissionCollection collection = this.authorizationPolicy.getPermissions(role);
                int priority = this.authorizationPolicy.getPriority(role);
                int comparator = this.resolve(priority, lastPriority[0]);
                result = result.merge(collection, comparator);
                if (priority <= lastPriority[0]) continue;
                lastPriority[0] = priority;
            }
        }
        return result;
    }

    private PermissionCollection mergeGroupPermissions(User user, PermissionCollection target, int[] lastPriority) {
        PermissionCollection result = target;
        if (user.getGroups() != null) {
            for (Group group : user.getGroups()) {
                PermissionCollection collection = this.authorizationPolicy.getPermissions(group);
                int priority = this.authorizationPolicy.getPriority(group);
                int comparator = this.resolve(priority, lastPriority[0]);
                result = result.merge(collection, comparator);
                if (priority <= lastPriority[0]) continue;
                lastPriority[0] = priority;
            }
        }
        return result;
    }

    private int resolve(int p1, int p2) {
        if (p1 == p2) {
            return 0;
        }
        if (p1 > p2) {
            return 1;
        }
        return -1;
    }
}

