/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.beryllium.redis;

import com.google.common.truth.Truth;
import cucumber.api.DataTable;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import java.util.Map;
import org.tomitribe.beryllium.redis.RedisUtil;
import redis.clients.jedis.Jedis;

public class RedisScoredMembersSteps {
    @Given(value="^I have the redis scored member \"([^\"]*)\"(?: in the db (\\d+))? with score \"([^\"]*)\" and value \"([^\"]*)\"$")
    public void iHaveTheRedisScoredMemberInTheDbWithScoreAndValue(String key, int database, String score, String value) {
        double scoreValue = Double.parseDouble(score);
        Jedis jedis = RedisUtil.getJedis(database);
        jedis.zadd(key, scoreValue, value);
        jedis.close();
    }

    @Given(value="^I have the redis scored members \"([^\"]*)\"(?: in the db (\\d+))? with values:$")
    public void iHaveTheRedisScoredMembersInTheDbWithValuesColon(String key, int database, DataTable dataTable) {
        Map table = dataTable.asMap(String.class, Double.class);
        Jedis jedis = RedisUtil.getJedis(database);
        jedis.zadd(key, table);
        jedis.close();
    }

    @Then(value="^I should have the redis scored member \"([^\"]*)\"(?: in the db (\\d+))? with score \"([^\"]*)\" and value \"([^\"]*)\"$")
    public void iShouldHaveTheRedisScoredMemberInTheDbWithScoreAndValue(String key, int database, String score, String value) {
        double scoredValue = Double.parseDouble(score);
        Jedis jedis = RedisUtil.getJedis(database);
        Truth.assertThat((Double)jedis.zscore(key, value)).isEqualTo(Double.valueOf(scoredValue));
        jedis.close();
    }

    @Then(value="^I should have the redis scored members \"([^\"]*)\"(?: in the db (\\d+))? with values:$")
    public void iShouldHaveTheRedisScoredMembersInTheDbWithValuesColon(String key, int database, DataTable dataTable) {
        Map table = dataTable.asMap(String.class, Double.class);
        Jedis jedis = RedisUtil.getJedis(database);
        for (Map.Entry entry : table.entrySet()) {
            Truth.assertThat((Double)jedis.zscore(key, (String)entry.getKey())).isEqualTo((Double)entry.getValue());
        }
        jedis.close();
    }
}

