/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.beryllium.redis;

import com.google.common.truth.Truth;
import cucumber.api.DataTable;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import org.tomitribe.beryllium.Utility;
import org.tomitribe.beryllium.redis.RedisUtil;
import redis.clients.jedis.Jedis;

public class RedisKeyValueSteps {
    @Given(value="^I have the redis key \"([^\"]*)\"(?: in the db (\\d+))? with value \"([^\"]*)\"$")
    public void iHaveTheRedisKeyWithValue(String key, Integer db, String value) throws Throwable {
        Jedis jedis = RedisUtil.getJedis(db);
        jedis.set(key, value);
        jedis.close();
    }

    @Given(value="^I have the redis key \"([^\"]*)\"(?: in the db (\\d+))? with value in file \"([^\"]*)\"$")
    public void iHaveTheRedisKeyInTheDbWithValueInFile(String key, Integer db, String filename) throws Throwable {
        this.iHaveTheRedisKeyWithValue(key, db, Utility.fileContent(filename));
    }

    @Given(value="^I have the redis key \"([^\"]*)\"(?: in the db (\\d+))? with value:$")
    public void iHaveTheRedisKeyInTheDbWithValue(String key, Integer db, String value) throws Throwable {
        this.iHaveTheRedisKeyWithValue(key, db, value);
    }

    @Then(value="^the redis key \"([^\"]*)\"(?: in the db (\\d+))? should be \"([^\"]*)\"$")
    public void theRedisKeyInTheDbShouldBe(String key, Integer db, String value) throws Throwable {
        Jedis jedis = RedisUtil.getJedis(db);
        Truth.assertThat((String)jedis.get(key)).isEqualTo((Object)value);
        jedis.close();
    }

    @Then(value="^the redis key \"([^\"]*)\"(?: in the db (\\d+))? should be:$")
    public void theRedisKeyInTheDbShouldBeColon(String key, Integer db, String value) throws Throwable {
        this.theRedisKeyInTheDbShouldBe(key, db, value);
    }

    @Then(value="^the redis key \"([^\"]*)\"(?: in the db (\\d+))? should be file \"([^\"]*)\"$")
    public void theRedisKeyInTheDbShouldBeFile(String key, Integer db, String value) throws Throwable {
        this.theRedisKeyInTheDbShouldBe(key, db, Utility.fileContent(value));
    }

    @Given(value="^I have the redis key \"([^\"]*)\"(?: in the db (\\d+))? with value \"([^\"]*)\" with ttl (\\d+) seconds$")
    public void iHaveTheRedisKeyInTheDbWithValueWithTTL(String key, Integer db, String value, int seconds) throws Throwable {
        this.iHaveTheRedisKeyWithValue(key, db, value);
        Jedis jedis = RedisUtil.getJedis(db);
        jedis.expire(key, seconds);
        jedis.close();
    }

    @Then(value="^the redis key \"([^\"]*)\"(?: in the db (\\d+))? should not exists after (\\d+) seconds$")
    public void theRedisKeyInTheDbShouldNotExistsAfterSeconds(String key, Integer db, int seconds) throws Throwable {
        Thread.sleep(seconds * 1000);
        this.theRedisKeyInTheDbShouldNotExists(key, db);
    }

    @Then(value="^the redis key \"([^\"]*)\"(?: in the db (\\d+))? should exists$")
    public void theRedisKeyInTheDbShouldExists(String key, Integer db) throws Throwable {
        Jedis jedis = RedisUtil.getJedis(db);
        Truth.assertThat((String)jedis.get(key)).isNotNull();
        jedis.close();
    }

    @Then(value="^the redis key \"([^\"]*)\"(?: in the db (\\d+))? should not exists$")
    public void theRedisKeyInTheDbShouldNotExists(String key, Integer db) throws Throwable {
        Jedis jedis = RedisUtil.getJedis(db);
        Truth.assertThat((String)jedis.get(key)).isNull();
        jedis.close();
    }

    @Then(value="^the redis keys(?: in the db (\\d+))? should exists:$")
    public void theRedisKeysInTheDbShouldExistsColon(Integer db, DataTable dataTable) throws Throwable {
        for (String key : dataTable.asList(String.class)) {
            this.theRedisKeysInTheDbShouldExists(key, db);
        }
    }

    @Then(value="^the redis keys \"([^\"]*)\"(?: in the db (\\d+))? should exists$")
    public void theRedisKeysInTheDbShouldExists(String keys, Integer db) throws Throwable {
        String[] split;
        for (String key : split = keys.split(",")) {
            this.theRedisKeyInTheDbShouldExists(key, db);
        }
    }

    @Then(value="^the redis keys \"([^\"]*)\"(?: in the db (\\d+))? should not exists$")
    public void theRedisKeysShouldNotExists(String keys, Integer db) throws Throwable {
        String[] split;
        for (String key : split = keys.split(",")) {
            this.theRedisKeyInTheDbShouldNotExists(key, db);
        }
    }
}

