/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.beryllium.db;

import com.google.common.io.Resources;
import com.google.common.truth.Truth;
import com.ninja_squad.dbsetup.DbSetup;
import com.ninja_squad.dbsetup.Operations;
import com.ninja_squad.dbsetup.destination.Destination;
import com.ninja_squad.dbsetup.destination.DriverManagerDestination;
import com.ninja_squad.dbsetup.operation.CompositeOperation;
import com.ninja_squad.dbsetup.operation.Insert;
import com.ninja_squad.dbsetup.operation.Operation;
import cucumber.api.DataTable;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import gherkin.formatter.model.DataTableRow;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.ScriptRunner;

public class DatabaseSteps {
    private static final Properties properties = new Properties();
    private final Destination destination = new DriverManagerDestination(properties.getProperty("database.url"), properties.getProperty("database.user"), properties.getProperty("database.password"));

    @Given(value="^I have the following rows in the \"(.*?)\" table:$")
    public void iHaveTheFollowingRowsInTheTable(String tableName, DataTable data) throws Throwable {
        this.insert(tableName, data);
    }

    @Given(value="^I have only the following rows in the \"([^\"]*)\" table:$")
    public void iHaveOnlyTheFollowingRowsInTheTable(String tableName, DataTable data) throws Throwable {
        this.deleteAll(tableName);
        this.insert(tableName, data);
    }

    void insert(String tableName, DataTable data) {
        List rows = data.getGherkinRows();
        List columns = ((DataTableRow)rows.get(0)).getCells();
        ArrayList<Insert> operations = new ArrayList<Insert>();
        for (DataTableRow row : rows.subList(1, rows.size())) {
            Insert.Builder builder = Insert.into((String)tableName);
            builder.columns(columns.toArray(new String[columns.size()]));
            builder.values((Object[])row.getCells().toArray(new String[row.getCells().size()]));
            operations.add(builder.build());
        }
        this.apply(CompositeOperation.sequenceOf(operations));
    }

    void deleteAll(String tableName) {
        this.apply((Operation)Operations.deleteAllFrom((String)tableName));
    }

    void apply(Operation operation) {
        new DbSetup(this.destination, operation).launch();
    }

    @Given(value="^I have the following sql script \"([^\"]*)\"$")
    public void iHaveTheFollowingSQLScript(String script) throws Throwable {
        new ScriptRunner(this.destination.getConnection()).runScript((Reader)new BufferedReader(new FileReader(Resources.getResource((String)script).getPath())));
    }

    @Then(value="^I should have the following rows in the \"([^\"]*)\" table:$")
    public void iShouldHaveTheFollowingRowsInTheTable(String tableName, DataTable data) throws SQLException, ClassNotFoundException {
        this.exists(tableName, data);
    }

    void exists(String tableName, DataTable data) throws SQLException, ClassNotFoundException {
        List rows = data.getGherkinRows();
        List columns = ((DataTableRow)rows.get(0)).getCells();
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(String.format("SELECT %s FROM %s WHERE ", StringUtils.join((Iterable)columns, (String)","), tableName));
        queryBuilder.append(StringUtils.join((Iterable)columns, (String)" = ? AND "));
        queryBuilder.append(" = ?;");
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement(queryBuilder.toString());
            for (DataTableRow row : rows.subList(1, rows.size())) {
                List rowValues = row.getCells();
                for (int i = 0; i < columns.size(); ++i) {
                    stmt.setString(i + 1, (String)rowValues.get(i));
                }
                ResultSet rs = stmt.executeQuery();
                Truth.assertThat((Boolean)rs.next()).isTrue();
            }
        }
    }

    private Connection getConnection() throws ClassNotFoundException, SQLException {
        Class.forName(properties.getProperty("database.driver"));
        return DriverManager.getConnection(properties.getProperty("database.url"), properties.getProperty("database.user"), properties.getProperty("database.password"));
    }

    static {
        try (InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream("test-db.properties");){
            properties.load(resource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

