/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.tinylog.Level;
import org.tinylog.core.LogEntry;
import org.tinylog.provider.InternalLogger;
import org.tinylog.writers.AbstractFormatPatternWriter;
import org.tinylog.writers.raw.ByteArrayWriter;

public final class SharedFileWriter
extends AbstractFormatPatternWriter {
    private final RandomAccessFile lockFile;
    private final FileLock lock;
    private final Charset charset;
    private final ByteArrayWriter writer;

    public SharedFileWriter() throws IOException {
        this(Collections.emptyMap());
    }

    public SharedFileWriter(Map<String, String> properties) throws IOException {
        super(properties);
        String fileName = SharedFileWriter.getFileName(properties);
        boolean append = Boolean.parseBoolean(properties.get("append"));
        boolean buffered = Boolean.parseBoolean(properties.get("buffered"));
        boolean writingThread = Boolean.parseBoolean(properties.get("writingthread"));
        if (append) {
            this.lockFile = null;
            this.lock = null;
        } else {
            this.lockFile = new RandomAccessFile(fileName + ".lock", "rw");
            FileLock exclusiveLock = this.lockFile.getChannel().tryLock(0L, Long.MAX_VALUE, false);
            if (exclusiveLock == null) {
                append = true;
            } else {
                exclusiveLock.release();
            }
            this.lock = this.lockFile.getChannel().lock(0L, Long.MAX_VALUE, true);
            if (!this.lock.isShared()) {
                append = true;
                this.lock.release();
                InternalLogger.log((Level)Level.WARN, (String)"Operating system does not support shared locks. Shared file writer will only work properly, if append mode is enabled.");
            }
        }
        this.charset = SharedFileWriter.getCharset(properties);
        this.writer = SharedFileWriter.createByteArrayWriter(fileName, append, buffered, !writingThread, true, this.charset);
    }

    @Override
    public void write(LogEntry logEntry) throws IOException {
        byte[] data = this.render(logEntry).getBytes(this.charset);
        this.writer.write(data, 0, data.length);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.writer.close();
        }
        finally {
            if (this.lockFile != null) {
                try {
                    this.lock.release();
                }
                finally {
                    this.lockFile.close();
                }
            }
        }
    }
}

