/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.policies;

import java.io.File;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinylog.policies.Policy;

public final class DailyPolicy
implements Policy {
    private static final Pattern TIME_PATTERN = Pattern.compile("^([01]?[0-9]|2[0-3])([^\\d]+([0-5]?[0-9]))?$");
    private static final int GROUP_HOUR = 1;
    private static final int GROUP_MINUTE = 3;
    private final Calendar calendar = Calendar.getInstance();

    public DailyPolicy(String argument) {
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        if (argument == null || argument.isEmpty()) {
            this.calendar.set(11, 0);
            this.calendar.set(12, 0);
        } else {
            Matcher matcher = TIME_PATTERN.matcher(argument);
            if (matcher.matches()) {
                String hour = matcher.group(1);
                String minute = matcher.group(3);
                this.calendar.set(11, Integer.parseInt(hour));
                this.calendar.set(12, minute == null ? 0 : Integer.parseInt(minute));
            } else {
                throw new IllegalArgumentException("Invalid time for daily policy: " + argument);
            }
        }
        this.reset();
    }

    @Override
    public boolean continueExistingFile(String path) {
        Calendar clone = (Calendar)this.calendar.clone();
        clone.add(5, -1);
        return clone.getTimeInMillis() <= new File(path).lastModified();
    }

    @Override
    public boolean continueCurrentFile(byte[] entry) {
        return this.calendar.getTimeInMillis() > System.currentTimeMillis();
    }

    @Override
    public void reset() {
        while (this.calendar.getTimeInMillis() <= System.currentTimeMillis()) {
            this.calendar.add(5, 1);
        }
    }
}

