/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.serviceplugin;

import org.tinygroup.cepcore.CEPCore;
import org.tinygroup.cepcore.EventProcessor;
import org.tinygroup.config.Configuration;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.plugin.Plugin;
import org.tinygroup.service.ServiceProviderInterface;
import org.tinygroup.serviceplugin.processor.ServiceProcessor;
import org.tinygroup.serviceplugin.processor.impl.ServiceProcessorImpl;
import org.tinygroup.xmlparser.node.XmlNode;

public class ServicePlugin
implements Plugin,
Configuration {
    private static Logger logger = LoggerFactory.getLogger(ServicePlugin.class);
    private XmlNode applicationConfig;
    private XmlNode componentConfig;
    private ServiceProcessor processor;
    private ServiceProviderInterface provider;
    private CEPCore cepcore;

    public ServiceProviderInterface getProvider() {
        return this.provider;
    }

    public void setProvider(ServiceProviderInterface provider) {
        this.provider = provider;
    }

    public CEPCore getCepcore() {
        return this.cepcore;
    }

    public void setCepcore(CEPCore cepcore) {
        this.cepcore = cepcore;
    }

    public String getApplicationNodePath() {
        return null;
    }

    public String getComponentConfigPath() {
        return null;
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        this.componentConfig = componentConfig;
        this.applicationConfig = applicationConfig;
    }

    private void initProcessors(XmlNode config) {
        logger.logMessage(LogLevel.DEBUG, "\u521d\u59cb\u5316ServiceProcessor");
        this.processor = new ServiceProcessorImpl();
        this.processor.setConfig(config);
        this.processor.addServiceProvider(this.provider);
        logger.logMessage(LogLevel.DEBUG, "\u521d\u59cb\u5316ServiceProcessor\u5b8c\u6210");
    }

    public XmlNode getComponentConfig() {
        return this.componentConfig;
    }

    public XmlNode getApplicationConfig() {
        return this.applicationConfig;
    }

    public void start() {
        this.initProcessors(this.applicationConfig);
        this.cepcore.registerEventProcessor((EventProcessor)this.processor);
    }

    public void stop() {
        this.cepcore.unregisterEventProcessor((EventProcessor)this.processor);
    }
}

