/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.vfs.impl.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.FileObjectFilter;

public class FilePathFileObjectFilter
implements FileObjectFilter {
    private Pattern pattern;
    private boolean fullMatch = false;

    public FilePathFileObjectFilter(String path) {
        this.pattern = Pattern.compile(path);
    }

    public FilePathFileObjectFilter(String fileNamePattern, boolean fullMatch) {
        this(fileNamePattern);
        this.fullMatch = fullMatch;
    }

    public boolean accept(FileObject fileObject) {
        String filePath = fileObject.getPath();
        if (this.fullMatch) {
            Matcher matcher = this.pattern.matcher(filePath);
            if (matcher.find()) {
                return matcher.group().equals(filePath);
            }
            return false;
        }
        Matcher matcher = this.pattern.matcher(filePath);
        return matcher.find();
    }
}

