/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.vfs.impl;

import java.io.File;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.impl.AbstractSchemaProvider;
import org.tinygroup.vfs.impl.ZipFileObject;

public class ZipSchemaProvider
extends AbstractSchemaProvider {
    public static final String ZIP = ".zip";
    public static final String ZIP_PROTOCAL = "zip:";

    public boolean isMatch(String resource) {
        String lowerCase = resource.toLowerCase();
        return lowerCase.startsWith(ZIP_PROTOCAL) || lowerCase.endsWith(ZIP) && new File(resource).exists();
    }

    public String getSchema() {
        return ZIP_PROTOCAL;
    }

    public FileObject resolver(String resourceResolve) {
        String resource = resourceResolve;
        if (resource.startsWith(ZIP_PROTOCAL)) {
            resource = resource.substring(ZIP_PROTOCAL.length());
        }
        if (resource.startsWith("file:")) {
            resource = resource.substring("file:".length());
        }
        return new ZipFileObject(this, this.getResourceResolve(resourceResolve, ZIP_PROTOCAL));
    }
}

