/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.vfs.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.tinygroup.commons.io.StreamUtil;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.SchemaProvider;
import org.tinygroup.vfs.VFSRuntimeException;
import org.tinygroup.vfs.impl.AbstractFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileObject
extends AbstractFileObject {
    private List<FileObject> children;
    private JarFile jarFile = null;
    private File file = null;
    private JarEntry jarEntry = null;
    private File cacheFile = null;

    public JarFileObject(SchemaProvider schemaProvider, String resource) {
        super(schemaProvider);
        try {
            this.file = new File(resource);
            if (this.file.exists()) {
                this.jarFile = new JarFile(resource);
            }
        }
        catch (IOException e) {
            throw new VFSRuntimeException(resource + "\u6253\u5f00\u5931\u8d25\uff0c\u9519\u8bef\uff1a" + e.getMessage(), e);
        }
    }

    @Override
    public void clean() {
        try {
            this.jarFile.close();
        }
        catch (IOException e) {
            throw new VFSRuntimeException(e);
        }
    }

    public JarFileObject(JarFileObject parent, JarEntry entry) {
        super(parent.getSchemaProvider());
        this.jarFile = parent.jarFile;
        this.file = parent.file;
        this.jarEntry = entry;
    }

    @Override
    public String getFileName() {
        if (this.jarEntry != null) {
            String[] names = this.jarEntry.getName().split("/");
            return names[names.length - 1];
        }
        return this.file.getName();
    }

    @Override
    public String getPath() {
        if (this.jarEntry != null) {
            return "/" + this.jarEntry.getName();
        }
        return "/";
    }

    @Override
    public String getAbsolutePath() {
        String path = this.file.getAbsolutePath();
        if (File.separatorChar == '\\') {
            path = path.replaceAll("\\\\", "/");
        }
        if (this.jarEntry != null) {
            path = path + "!/" + this.jarEntry.getName();
        }
        return path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getExtName() {
        String name;
        if (this.jarEntry != null) {
            if (this.jarEntry.isDirectory()) return null;
            name = this.jarEntry.getName();
        } else {
            name = this.file.getName();
        }
        int lastIndexOfDot = name.lastIndexOf(46);
        if (lastIndexOfDot != -1) return name.substring(lastIndexOfDot + 1);
        return null;
    }

    @Override
    public long getSize() {
        if (this.jarEntry != null) {
            return this.jarEntry.getSize();
        }
        if (this.file.exists() && this.file.isFile()) {
            return this.file.length();
        }
        return 0L;
    }

    @Override
    public InputStream getInputStream() {
        try {
            if (this.jarEntry != null) {
                if (this.cacheFile == null || !this.cacheFile.exists() || this.cacheFile.length() != this.getSize()) {
                    this.createCacheFile();
                    FileOutputStream out = new FileOutputStream(this.cacheFile);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(this.jarFile.getInputStream(this.jarEntry));
                    StreamUtil.io((InputStream)bufferedInputStream, (OutputStream)out, (boolean)true, (boolean)true);
                }
                return new BufferedInputStream(new FileInputStream(this.cacheFile));
            }
            if (this.file.exists() && this.file.isFile()) {
                return new JarInputStream(new FileInputStream(this.file));
            }
            throw new VFSRuntimeException(this.file.getAbsolutePath() + "\u4e0d\u5b58\u5728\uff0c\u6216\u4e0d\u662f\u6587\u4ef6\u3002");
        }
        catch (Exception e) {
            throw new VFSRuntimeException(this.file.getAbsolutePath() + "\u83b7\u53d6FileInputStream\u51fa\u9519\uff0c\u539f\u56e0" + e);
        }
    }

    public String toString() {
        return this.getURL().toString();
    }

    @Override
    public boolean isFolder() {
        if (this.jarEntry != null) {
            return this.jarEntry.isDirectory();
        }
        return true;
    }

    @Override
    public List<FileObject> getChildren() {
        if (this.children == null) {
            if (!this.file.exists()) {
                return null;
            }
            this.createJarEntry();
        }
        return this.children;
    }

    private void createJarEntry() {
        this.children = new ArrayList<FileObject>();
        Enumeration<JarEntry> e = this.jarFile.entries();
        while (e.hasMoreElements()) {
            String fn;
            String[] names;
            JarEntry entry = e.nextElement();
            if (this.getParent() == null) {
                String[] names2 = entry.getName().split("/");
                if (names2.length != 1) continue;
                this.addSubItem(entry);
                continue;
            }
            String parentName = this.jarEntry.getName();
            if (entry.getName().equals(this.jarEntry.getName()) || !entry.getName().startsWith(parentName) || (names = (fn = entry.getName().substring(parentName.length())).split("/")).length != 1) continue;
            this.addSubItem(entry);
        }
    }

    private void addSubItem(JarEntry entry) {
        JarFileObject jarFileObject = new JarFileObject(this, entry);
        jarFileObject.setParent(this);
        this.children.add(jarFileObject);
    }

    @Override
    public long getLastModifiedTime() {
        if (this.jarEntry != null) {
            return this.jarEntry.getTime();
        }
        return this.file.lastModified();
    }

    @Override
    public boolean isExist() {
        if (this.jarEntry != null) {
            return true;
        }
        return this.file.exists();
    }

    @Override
    public boolean isInPackage() {
        return this.jarFile != null;
    }

    @Override
    public FileObject getChild(String fileName) {
        if (this.getChildren() != null) {
            for (FileObject fileObject : this.getChildren()) {
                if (!fileObject.getFileName().equals(fileName)) continue;
                return fileObject;
            }
        }
        return null;
    }

    @Override
    public URL getURL() {
        try {
            if (this.jarEntry != null) {
                return new URL("jar:file:" + this.getAbsolutePath());
            }
            return new URL("file:" + this.getAbsolutePath());
        }
        catch (MalformedURLException e) {
            throw new VFSRuntimeException(e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            if (this.jarEntry != null) {
                if (this.cacheFile == null || !this.cacheFile.exists() || this.cacheFile.length() != this.getSize()) {
                    this.createCacheFile();
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(this.jarFile.getInputStream(this.jarEntry));
                    FileOutputStream out = new FileOutputStream(this.cacheFile);
                    StreamUtil.io((InputStream)bufferedInputStream, (OutputStream)out, (boolean)true, (boolean)true);
                }
                return new BufferedOutputStream(new FileOutputStream(this.cacheFile));
            }
            if (this.file.exists() && this.file.isFile()) {
                return new JarOutputStream(new FileOutputStream(this.file));
            }
            throw new VFSRuntimeException(this.file.getAbsolutePath() + "\u4e0d\u5b58\u5728\uff0c\u6216\u4e0d\u662f\u6587\u4ef6\u3002");
        }
        catch (Exception e) {
            throw new VFSRuntimeException(this.file.getAbsolutePath() + "\u83b7\u53d6outputStream\u51fa\u9519\uff0c\u539f\u56e0" + e);
        }
    }

    private void createCacheFile() {
        File tempPathFile;
        String tempPath = System.getProperty("java.io.tmpdir");
        if (!tempPath.endsWith(File.separator)) {
            tempPath = tempPath + File.separator;
        }
        if (!(tempPathFile = new File(tempPath = tempPath + this.getExtName() + File.separator)).exists()) {
            tempPathFile.mkdirs();
        }
        this.cacheFile = new File(tempPath + this.getFileName() + "_" + this.getLastModifiedTime());
    }
}

