/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.vfs.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.SchemaProvider;
import org.tinygroup.vfs.VFS;
import org.tinygroup.vfs.VFSRuntimeException;
import org.tinygroup.vfs.impl.AbstractFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileObjectImpl
extends AbstractFileObject {
    private String path;
    private List<FileObject> children;
    private File file = null;
    long lastModifiedTime = 0L;
    private byte[] lockObject = new byte[0];

    public FileObjectImpl(SchemaProvider schemaProvider, String resource) {
        super(schemaProvider);
        this.init(new File(resource));
    }

    @Override
    public boolean isModified() {
        return this.lastModifiedTime != this.file.lastModified();
    }

    @Override
    public void resetModified() {
        this.lastModifiedTime = this.file.lastModified();
    }

    private void init(File file) {
        this.file = file;
        if (file.exists()) {
            this.lastModifiedTime = file.lastModified();
        }
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    public FileObjectImpl(SchemaProvider schemaProvider, File file) {
        super(schemaProvider);
        this.init(file);
    }

    @Override
    public String getFileName() {
        return this.file.getName();
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            if (this.getParent() != null) {
                this.path = this.getParent().getPath() + "/" + this.getFileName();
            } else {
                if (this.file.isDirectory()) {
                    return "";
                }
                return "/" + this.file.getName();
            }
        }
        return this.path;
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public String getExtName() {
        int lastIndexOfDot = this.file.getName().lastIndexOf(".");
        if (lastIndexOfDot == -1) {
            return null;
        }
        return this.file.getName().substring(lastIndexOfDot + 1);
    }

    @Override
    public long getSize() {
        if (this.file.exists() && this.file.isFile()) {
            return this.file.length();
        }
        return 0L;
    }

    @Override
    public InputStream getInputStream() {
        try {
            if (this.file.exists() && this.file.isFile()) {
                return new BufferedInputStream(new FileInputStream(this.file));
            }
            return null;
        }
        catch (FileNotFoundException e) {
            throw new VFSRuntimeException(this.file.getAbsolutePath() + "\u83b7\u53d6FileInputStream\u51fa\u9519\uff0c\u539f\u56e0" + e);
        }
    }

    @Override
    public boolean isFolder() {
        if (this.file.exists()) {
            return this.file.isDirectory();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<FileObject> getChildren() {
        if (!this.isModified() && !CollectionUtil.isEmpty(this.children)) return this.children;
        byte[] byArray = this.lockObject;
        synchronized (this.lockObject) {
            this.children = this.forEachFile();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.children;
        }
    }

    private List<FileObject> forEachFile() {
        ArrayList<FileObject> children = new ArrayList<FileObject>();
        if (this.file.exists() && this.file.isDirectory()) {
            File[] subFiles;
            for (File subfile : subFiles = this.file.listFiles()) {
                FileObject fileObject = null;
                if (subfile.getName().endsWith(".jar") && !subfile.isDirectory()) {
                    fileObject = VFS.resolveFile(subfile.getAbsolutePath());
                } else {
                    fileObject = new FileObjectImpl(this.getSchemaProvider(), subfile);
                    fileObject.setParent(this);
                }
                children.add(fileObject);
            }
        }
        return children;
    }

    @Override
    public long getLastModifiedTime() {
        return this.file.lastModified();
    }

    @Override
    public boolean isExist() {
        return this.file.exists();
    }

    @Override
    public boolean isInPackage() {
        return false;
    }

    @Override
    public FileObject getChild(String fileName) {
        if (this.getChildren() != null) {
            for (FileObject fileObject : this.getChildren()) {
                if (!fileObject.getFileName().equals(fileName)) continue;
                return fileObject;
            }
        }
        return null;
    }

    @Override
    public URL getURL() {
        try {
            return new URL("file:" + this.getAbsolutePath());
        }
        catch (MalformedURLException e) {
            throw new VFSRuntimeException(e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            return new FileOutputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new VFSRuntimeException(e);
        }
    }
}

